/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.client.Result;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Array;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyDecoder;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.lookup.LookupStringTable;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.storage.hbase.steps.RowValueDecoder;

public class CubeTupleConverter {
    final CubeSegment cubeSeg;
    final Cuboid cuboid;
    final TupleInfo tupleInfo;
    final RowKeyDecoder rowKeyDecoder;
    final List<RowValueDecoder> rowValueDecoders;
    final List<IDerivedColumnFiller> derivedColFillers;
    final int[] dimensionTupleIdx;
    final int[][] metricsMeasureIdx;
    final int[][] metricsTupleIdx;
    final List<MeasureType<?>> measureTypes;
    final List<MeasureType.IAdvMeasureFiller> advMeasureFillers;
    final List<Pair<Integer, Integer>> advMeasureIndexInRV;

    public CubeTupleConverter(CubeSegment cubeSeg, Cuboid cuboid, List<RowValueDecoder> rowValueDecoders, TupleInfo tupleInfo) {
        int i;
        this.cubeSeg = cubeSeg;
        this.cuboid = cuboid;
        this.tupleInfo = tupleInfo;
        this.rowKeyDecoder = new RowKeyDecoder(this.cubeSeg);
        this.rowValueDecoders = rowValueDecoders;
        this.derivedColFillers = Lists.newArrayList();
        List dimCols = cuboid.getColumns();
        this.measureTypes = Lists.newArrayList();
        this.advMeasureFillers = Lists.newArrayListWithCapacity((int)1);
        this.advMeasureIndexInRV = Lists.newArrayListWithCapacity((int)1);
        this.dimensionTupleIdx = new int[dimCols.size()];
        for (i = 0; i < dimCols.size(); ++i) {
            TblColRef col = (TblColRef)dimCols.get(i);
            this.dimensionTupleIdx[i] = tupleInfo.hasColumn(col) ? tupleInfo.getColumnIndex(col) : -1;
        }
        this.metricsMeasureIdx = new int[rowValueDecoders.size()][];
        this.metricsTupleIdx = new int[rowValueDecoders.size()][];
        for (i = 0; i < rowValueDecoders.size(); ++i) {
            RowValueDecoder decoder = rowValueDecoders.get(i);
            MeasureDesc[] measures = decoder.getMeasures();
            BitSet selectedMeasures = decoder.getProjectionIndex();
            this.metricsMeasureIdx[i] = new int[selectedMeasures.cardinality()];
            this.metricsTupleIdx[i] = new int[selectedMeasures.cardinality()];
            int mi = selectedMeasures.nextSetBit(0);
            for (int j = 0; j < this.metricsMeasureIdx[i].length; ++j) {
                TblColRef col;
                String rewriteFieldName;
                FunctionDesc aggrFunc = measures[mi].getFunction();
                int tupleIdx = aggrFunc.needRewrite() ? (tupleInfo.hasField(rewriteFieldName = aggrFunc.getRewriteFieldName()) ? tupleInfo.getFieldIndex(rewriteFieldName) : -1) : (tupleInfo.hasColumn(col = (TblColRef)aggrFunc.getParameter().getColRefs().get(0)) ? tupleInfo.getColumnIndex(col) : -1);
                this.metricsMeasureIdx[i][j] = mi;
                this.metricsTupleIdx[i][j] = tupleIdx;
                MeasureType measureType = aggrFunc.getMeasureType();
                if (measureType.needAdvancedTupleFilling()) {
                    Map<TblColRef, Dictionary<String>> dictionaryMap = this.buildDictionaryMap(measureType.getColumnsNeedDictionary(aggrFunc));
                    this.advMeasureFillers.add(measureType.getAdvancedTupleFiller(aggrFunc, tupleInfo, dictionaryMap));
                    this.advMeasureIndexInRV.add((Pair<Integer, Integer>)Pair.newPair((Object)i, (Object)mi));
                    this.measureTypes.add(null);
                } else {
                    this.measureTypes.add(measureType);
                }
                mi = selectedMeasures.nextSetBit(mi + 1);
            }
        }
        Map hostToDerivedInfo = cuboid.getCubeDesc().getHostToDerivedInfo(dimCols, null);
        for (Map.Entry entry : hostToDerivedInfo.entrySet()) {
            TblColRef[] hostCols = (TblColRef[])((Array)entry.getKey()).data;
            for (CubeDesc.DeriveInfo deriveInfo : (List)entry.getValue()) {
                IDerivedColumnFiller filler = this.newDerivedColumnFiller(hostCols, deriveInfo);
                if (filler == null) continue;
                this.derivedColFillers.add(filler);
            }
        }
    }

    private Map<TblColRef, Dictionary<String>> buildDictionaryMap(List<TblColRef> columnsNeedDictionary) {
        HashMap result = Maps.newHashMap();
        for (TblColRef col : columnsNeedDictionary) {
            result.put(col, this.cubeSeg.getDictionary(col));
        }
        return result;
    }

    public List<MeasureType.IAdvMeasureFiller> translateResult(Result hbaseRow, Tuple tuple) {
        int i;
        try {
            byte[] rowkey = hbaseRow.getRow();
            this.rowKeyDecoder.decode(rowkey);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot translate hbase result " + hbaseRow);
        }
        List dimensionValues = this.rowKeyDecoder.getValues();
        for (int i2 = 0; i2 < dimensionValues.size(); ++i2) {
            int tupleIdx = this.dimensionTupleIdx[i2];
            if (tupleIdx < 0) continue;
            tuple.setDimensionValue(tupleIdx, (String)dimensionValues.get(i2));
        }
        for (IDerivedColumnFiller filler : this.derivedColFillers) {
            filler.fillDerivedColumns(dimensionValues, tuple);
        }
        int index = 0;
        for (i = 0; i < this.rowValueDecoders.size(); ++i) {
            RowValueDecoder rowValueDecoder = this.rowValueDecoders.get(i);
            rowValueDecoder.decodeAndConvertJavaObj(hbaseRow);
            Object[] measureValues = rowValueDecoder.getValues();
            int[] measureIdx = this.metricsMeasureIdx[i];
            int[] tupleIdx = this.metricsTupleIdx[i];
            for (int j = 0; j < measureIdx.length; ++j) {
                if (this.measureTypes.get(index++) == null) continue;
                tuple.setMeasureValue(tupleIdx[j], measureValues[measureIdx[j]]);
            }
        }
        if (this.advMeasureFillers.isEmpty()) {
            return null;
        }
        for (i = 0; i < this.advMeasureFillers.size(); ++i) {
            Pair<Integer, Integer> metricLocation = this.advMeasureIndexInRV.get(i);
            Object measureValue = this.rowValueDecoders.get((Integer)metricLocation.getFirst()).getValues()[(Integer)metricLocation.getSecond()];
            this.advMeasureFillers.get(i).reload(measureValue);
        }
        return this.advMeasureFillers;
    }

    private IDerivedColumnFiller newDerivedColumnFiller(TblColRef[] hostCols, final CubeDesc.DeriveInfo deriveInfo) {
        List rowColumns = this.cuboid.getColumns();
        final int[] hostColIdx = new int[hostCols.length];
        for (int i = 0; i < hostCols.length; ++i) {
            hostColIdx[i] = rowColumns.indexOf(hostCols[i]);
        }
        boolean needCopyDerived = false;
        final int[] derivedTupleIdx = new int[deriveInfo.columns.length];
        for (int i = 0; i < deriveInfo.columns.length; ++i) {
            TblColRef col = deriveInfo.columns[i];
            derivedTupleIdx[i] = this.tupleInfo.hasColumn(col) ? this.tupleInfo.getColumnIndex(col) : -1;
            needCopyDerived = needCopyDerived || derivedTupleIdx[i] >= 0;
        }
        if (!needCopyDerived) {
            return null;
        }
        switch (deriveInfo.type) {
            case LOOKUP: {
                return new IDerivedColumnFiller(){
                    CubeManager cubeMgr;
                    LookupStringTable lookupTable;
                    int[] derivedColIdx;
                    Array<String> lookupKey;
                    {
                        this.cubeMgr = CubeManager.getInstance((KylinConfig)CubeTupleConverter.this.cubeSeg.getCubeInstance().getConfig());
                        this.lookupTable = this.cubeMgr.getLookupTable(CubeTupleConverter.this.cubeSeg, deriveInfo.dimension);
                        this.derivedColIdx = this.initDerivedColIdx();
                        this.lookupKey = new Array((Object[])new String[hostColIdx.length]);
                    }

                    private int[] initDerivedColIdx() {
                        int[] idx = new int[deriveInfo.columns.length];
                        for (int i = 0; i < idx.length; ++i) {
                            idx[i] = deriveInfo.columns[i].getColumnDesc().getZeroBasedIndex();
                        }
                        return idx;
                    }

                    @Override
                    public void fillDerivedColumns(List<String> rowValues, Tuple tuple) {
                        for (int i = 0; i < hostColIdx.length; ++i) {
                            ((String[])this.lookupKey.data)[i] = rowValues.get(hostColIdx[i]);
                        }
                        String[] lookupRow = (String[])this.lookupTable.getRow(this.lookupKey);
                        if (lookupRow != null) {
                            for (int i = 0; i < derivedTupleIdx.length; ++i) {
                                if (derivedTupleIdx[i] < 0) continue;
                                String value = lookupRow[this.derivedColIdx[i]];
                                tuple.setDimensionValue(derivedTupleIdx[i], value);
                            }
                        } else {
                            for (int i = 0; i < derivedTupleIdx.length; ++i) {
                                if (derivedTupleIdx[i] < 0) continue;
                                tuple.setDimensionValue(derivedTupleIdx[i], null);
                            }
                        }
                    }
                };
            }
            case PK_FK: {
                return new IDerivedColumnFiller(){

                    @Override
                    public void fillDerivedColumns(List<String> rowValues, Tuple tuple) {
                        tuple.setDimensionValue(derivedTupleIdx[0], rowValues.get(hostColIdx[0]));
                    }
                };
            }
        }
        throw new IllegalArgumentException();
    }

    private static interface IDerivedColumnFiller {
        public void fillDerivedColumns(List<String> var1, Tuple var2);
    }
}

