/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTStore;
import org.apache.kylin.gridtable.IGTWriter;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.steps.CubeHTableUtil;

public class SimpleHBaseStore
implements IGTStore {
    static final String CF = "F";
    static final byte[] CF_B = Bytes.toBytes((String)"F");
    static final String COL = "C";
    static final byte[] COL_B = Bytes.toBytes((String)"C");
    static final int ID_LEN = 8;
    final GTInfo info;
    final TableName htableName;

    public SimpleHBaseStore(GTInfo info, TableName htable) {
        this.info = info;
        this.htableName = htable;
    }

    public GTInfo getInfo() {
        return this.info;
    }

    public void cleanup() throws IOException {
        CubeHTableUtil.deleteHTable(this.htableName);
    }

    public IGTWriter rebuild() throws IOException {
        CubeHTableUtil.createBenchmarkHTable(this.htableName, CF);
        return new Writer();
    }

    public IGTWriter append() throws IOException {
        return new Writer();
    }

    public IGTScanner scan(GTScanRequest scanRequest) throws IOException {
        return new Reader();
    }

    class Reader
    implements IGTScanner {
        final HTableInterface table;
        final ResultScanner scanner;
        int count = 0;

        Reader() throws IOException {
            HConnection conn = HBaseConnection.get(KylinConfig.getInstanceFromEnv().getStorageUrl());
            this.table = conn.getTable(SimpleHBaseStore.this.htableName);
            Scan scan = new Scan();
            scan.addFamily(CF_B);
            scan.setCaching(1024);
            scan.setCacheBlocks(true);
            this.scanner = this.table.getScanner(scan);
        }

        public ResultScanner getHBaseScanner() {
            return this.scanner;
        }

        public Iterator<GTRecord> iterator() {
            return new Iterator<GTRecord>(){
                GTRecord next = null;
                GTRecord rec;
                {
                    this.rec = new GTRecord(SimpleHBaseStore.this.info);
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    try {
                        Result r = Reader.this.scanner.next();
                        if (r != null) {
                            this.loadRecord(r);
                            this.next = this.rec;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return this.next != null;
                }

                private void loadRecord(Result r) {
                    Cell[] cells = r.rawCells();
                    Cell cell = cells[0];
                    if (Bytes.compareTo((byte[])CF_B, (int)0, (int)CF_B.length, (byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength()) != 0 || Bytes.compareTo((byte[])COL_B, (int)0, (int)COL_B.length, (byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength()) != 0) {
                        throw new IllegalStateException();
                    }
                    this.rec.loadCellBlock(0, ByteBuffer.wrap(cell.getRowArray(), cell.getRowOffset() + 8, cell.getRowLength() - 8));
                    this.rec.loadCellBlock(1, ByteBuffer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
                }

                @Override
                public GTRecord next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ++Reader.this.count;
                    this.next = null;
                    return this.rec;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public void close() throws IOException {
            this.scanner.close();
            this.table.close();
        }

        public GTInfo getInfo() {
            return SimpleHBaseStore.this.info;
        }

        public long getScannedRowCount() {
            return this.count;
        }
    }

    private class Writer
    implements IGTWriter {
        final HTableInterface table;
        final ByteBuffer rowkey = ByteBuffer.allocate(50);
        final ByteBuffer value = ByteBuffer.allocate(50);

        Writer() throws IOException {
            HConnection conn = HBaseConnection.get(KylinConfig.getInstanceFromEnv().getStorageUrl());
            this.table = conn.getTable(SimpleHBaseStore.this.htableName);
            this.table.setAutoFlush(false, true);
        }

        public void write(GTRecord rec) throws IOException {
            assert (SimpleHBaseStore.this.info.getColumnBlockCount() == 2);
            this.rowkey.clear();
            for (int i = 0; i < 8; ++i) {
                this.rowkey.put((byte)0);
            }
            rec.exportColumnBlock(0, this.rowkey);
            this.rowkey.flip();
            this.value.clear();
            rec.exportColumnBlock(1, this.value);
            this.value.flip();
            Put put = new Put(this.rowkey);
            put.addImmutable(CF_B, ByteBuffer.wrap(COL_B), Long.MAX_VALUE, this.value);
            this.table.put(put);
        }

        public void close() throws IOException {
            this.table.flushCommits();
            this.table.close();
        }
    }
}

