/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube;

import java.io.IOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTSampleCodeSystem;
import org.apache.kylin.gridtable.GTScanRequestBuilder;
import org.apache.kylin.gridtable.IGTCodeSystem;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTWriter;
import org.apache.kylin.gridtable.benchmark.SortedGTRecordGenerator;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.storage.hbase.cube.SimpleHBaseStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseScannerBenchmark {
    static final Logger logger = LoggerFactory.getLogger(HBaseScannerBenchmark.class);
    final GTInfo info;
    final SortedGTRecordGenerator gen;
    final ImmutableBitSet dimensions = ImmutableBitSet.valueOf((int[])new int[]{0, 1, 2, 3, 4});
    final ImmutableBitSet metrics = ImmutableBitSet.valueOf((int[])new int[]{5, 6});
    final String[] aggrFuncs = new String[]{"SUM", "SUM"};
    final long N = 1000000L;
    final TableName htableName = TableName.valueOf((String)"HBaseScannerBenchmark");
    final SimpleHBaseStore simpleStore;

    public HBaseScannerBenchmark() throws IOException {
        GTInfo.Builder builder = GTInfo.builder();
        builder.setCodeSystem((IGTCodeSystem)new GTSampleCodeSystem());
        DataType tint = DataType.getType((String)"int4");
        DataType tlong = DataType.getType((String)"long8");
        builder.setColumns(new DataType[]{tint, tint, tint, tint, tint, tlong, tlong});
        builder.setPrimaryKey(ImmutableBitSet.valueOf((int[])new int[]{0, 1, 2, 3, 4}));
        this.info = builder.build();
        this.gen = new SortedGTRecordGenerator(this.info);
        this.gen.addDimension(10L, 4, null);
        this.gen.addDimension(10L, 4, null);
        this.gen.addDimension(10L, 4, null);
        this.gen.addDimension(10L, 4, null);
        this.gen.addDimension(100L, 4, null);
        this.gen.addMeasure(8);
        this.gen.addMeasure(8);
        this.simpleStore = new SimpleHBaseStore(this.info, this.htableName);
    }

    private void buildTable() throws IOException {
        IGTWriter builder = this.simpleStore.rebuild();
        logger.info("Writing 1000000 records");
        long t = System.currentTimeMillis();
        long count = 0L;
        for (GTRecord rec : this.gen.generate(1000000L)) {
            builder.write(rec);
            if (++count % 100000L != 0L) continue;
            logger.info(count + " rows written");
        }
        builder.close();
        t = System.currentTimeMillis() - t;
        logger.info(count + " rows written, " + this.speed(t) + "K row/sec");
    }

    public void testScan() throws IOException {
        int rounds = 5;
        for (int i = 0; i < rounds; ++i) {
            this.testScanRaw("Scan raw " + (i + 1) + " of " + rounds);
            this.testScanRecords("Scan records " + (i + 1) + " of " + rounds);
        }
    }

    private void testScanRaw(String msg) throws IOException {
        long t = System.currentTimeMillis();
        IGTScanner scan = this.simpleStore.scan(new GTScanRequestBuilder().setInfo(this.info).setRanges(null).setDimensions(null).setFilterPushDown(null).createGTScanRequest());
        ResultScanner innerScanner = ((SimpleHBaseStore.Reader)scan).getHBaseScanner();
        int count = 0;
        for (Result r : innerScanner) {
            ++count;
        }
        scan.close();
        t = System.currentTimeMillis() - t;
        logger.info(msg + ", " + count + " rows, " + this.speed(t) + "K row/sec");
    }

    private void testScanRecords(String msg) throws IOException {
        long t = System.currentTimeMillis();
        IGTScanner scan = this.simpleStore.scan(new GTScanRequestBuilder().setInfo(this.info).setRanges(null).setDimensions(null).setFilterPushDown(null).createGTScanRequest());
        int count = 0;
        for (GTRecord rec : scan) {
            ++count;
        }
        scan.close();
        if (scan.getScannedRowCount() != (long)count) {
            throw new IllegalStateException();
        }
        t = System.currentTimeMillis() - t;
        logger.info(msg + ", " + count + " records, " + this.speed(t) + "K rec/sec");
    }

    private int speed(long t) {
        double sec = (double)t / 1000.0;
        return (int)(1000000.0 / sec / 1000.0);
    }

    public void cleanup() throws IOException {
        this.simpleStore.cleanup();
    }

    public static void main(String[] args) throws IOException {
        boolean createTable = true;
        boolean deleteTable = true;
        if (args != null && args.length > 1) {
            try {
                createTable = Boolean.parseBoolean(args[0]);
            }
            catch (Exception e) {
                createTable = true;
            }
            try {
                deleteTable = Boolean.parseBoolean(args[1]);
            }
            catch (Exception e) {
                deleteTable = true;
            }
        }
        KylinConfig.setSandboxEnvIfPossible();
        HBaseScannerBenchmark benchmark = new HBaseScannerBenchmark();
        if (createTable) {
            benchmark.buildTable();
        }
        benchmark.testScan();
        if (deleteTable) {
            benchmark.cleanup();
        }
    }
}

