/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.kv.RowKeyColumnIO;
import org.apache.kylin.dict.BuiltInFunctionTransformer;
import org.apache.kylin.dict.DictCodeSystem;
import org.apache.kylin.dimension.IDimensionEncodingMap;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.TblColRef;

public class FilterDecorator
implements TupleFilterSerializer.Decorator {
    private IDimensionEncodingMap dimEncMap;
    private RowKeyColumnIO columnIO;
    private Set<TblColRef> inevaluableColumns;
    private FilterConstantsTreatment filterConstantsTreatment;

    public FilterDecorator(IDimensionEncodingMap dimEncMap, FilterConstantsTreatment filterConstantsTreatment) {
        this.dimEncMap = dimEncMap;
        this.columnIO = new RowKeyColumnIO(dimEncMap);
        this.inevaluableColumns = Sets.newHashSet();
        this.filterConstantsTreatment = filterConstantsTreatment;
    }

    public Set<TblColRef> getInevaluableColumns() {
        return this.inevaluableColumns;
    }

    private TupleFilter replaceConstantsWithLocalDict(CompareTupleFilter oldCompareFilter, CompareTupleFilter newCompareFilter) {
        return this.replaceConstantsWithGlobalDict(oldCompareFilter, newCompareFilter);
    }

    private TupleFilter replaceConstantsWithGlobalDict(CompareTupleFilter oldCompareFilter, CompareTupleFilter newCompareFilter) {
        ConstantTupleFilter result;
        Set constValues = oldCompareFilter.getValues();
        String firstValue = (String)constValues.iterator().next();
        TblColRef col = newCompareFilter.getColumn();
        switch (newCompareFilter.getOperator()) {
            case EQ: 
            case IN: {
                HashSet newValues = Sets.newHashSet();
                for (String value : constValues) {
                    String v = this.translate(col, value, 0);
                    if (this.isDictNull(v)) continue;
                    newValues.add(v);
                }
                if (newValues.isEmpty()) {
                    result = ConstantTupleFilter.FALSE;
                    break;
                }
                newCompareFilter.addChild((TupleFilter)new ConstantTupleFilter((Collection)newValues));
                result = newCompareFilter;
                break;
            }
            case NEQ: {
                String v = this.translate(col, firstValue, 0);
                if (this.isDictNull(v)) {
                    result = ConstantTupleFilter.TRUE;
                    break;
                }
                newCompareFilter.addChild((TupleFilter)new ConstantTupleFilter((Object)v));
                result = newCompareFilter;
                break;
            }
            case LT: {
                String v = this.translate(col, firstValue, 1);
                if (this.isDictNull(v)) {
                    result = ConstantTupleFilter.TRUE;
                    break;
                }
                newCompareFilter.addChild((TupleFilter)new ConstantTupleFilter((Object)v));
                result = newCompareFilter;
                break;
            }
            case LTE: {
                String v = this.translate(col, firstValue, -1);
                if (this.isDictNull(v)) {
                    result = ConstantTupleFilter.FALSE;
                    break;
                }
                newCompareFilter.addChild((TupleFilter)new ConstantTupleFilter((Object)v));
                result = newCompareFilter;
                break;
            }
            case GT: {
                String v = this.translate(col, firstValue, -1);
                if (this.isDictNull(v)) {
                    result = ConstantTupleFilter.TRUE;
                    break;
                }
                newCompareFilter.addChild((TupleFilter)new ConstantTupleFilter((Object)v));
                result = newCompareFilter;
                break;
            }
            case GTE: {
                String v = this.translate(col, firstValue, 1);
                if (this.isDictNull(v)) {
                    result = ConstantTupleFilter.FALSE;
                    break;
                }
                newCompareFilter.addChild((TupleFilter)new ConstantTupleFilter((Object)v));
                result = newCompareFilter;
                break;
            }
            default: {
                throw new IllegalStateException("Cannot handle operator " + newCompareFilter.getOperator());
            }
        }
        return result;
    }

    private boolean isDictNull(String v) {
        return DictCodeSystem.INSTANCE.isNull(v);
    }

    public TupleFilter onSerialize(TupleFilter filter) {
        if (filter == null) {
            return null;
        }
        BuiltInFunctionTransformer translator = new BuiltInFunctionTransformer(this.dimEncMap);
        if (!(filter = translator.transform(filter)).isEvaluable()) {
            TupleFilter.collectColumns((TupleFilter)filter, this.inevaluableColumns);
            return ConstantTupleFilter.TRUE;
        }
        if (!(filter instanceof CompareTupleFilter)) {
            return filter;
        }
        if (!TupleFilter.isEvaluableRecursively((TupleFilter)filter)) {
            TupleFilter.collectColumns((TupleFilter)filter, this.inevaluableColumns);
            return ConstantTupleFilter.TRUE;
        }
        if (this.filterConstantsTreatment == FilterConstantsTreatment.AS_IT_IS) {
            return filter;
        }
        CompareTupleFilter compareFilter = (CompareTupleFilter)filter;
        TblColRef col = compareFilter.getColumn();
        if (col == null) {
            return filter;
        }
        Set constValues = compareFilter.getValues();
        if (constValues == null || constValues.isEmpty()) {
            return filter;
        }
        CompareTupleFilter newCompareFilter = new CompareTupleFilter(compareFilter.getOperator());
        newCompareFilter.addChild((TupleFilter)new ColumnTupleFilter(col));
        if (this.filterConstantsTreatment == FilterConstantsTreatment.REPLACE_WITH_GLOBAL_DICT) {
            return this.replaceConstantsWithGlobalDict(compareFilter, newCompareFilter);
        }
        if (this.filterConstantsTreatment == FilterConstantsTreatment.REPLACE_WITH_LOCAL_DICT) {
            return this.replaceConstantsWithLocalDict(compareFilter, newCompareFilter);
        }
        throw new RuntimeException("should not reach here");
    }

    private String translate(TblColRef column, String v, int roundingFlag) {
        byte[] value = Bytes.toBytes((String)v);
        byte[] id = new byte[this.dimEncMap.get(column).getLengthOfEncoding()];
        this.columnIO.writeColumn(column, value, value.length, roundingFlag, (byte)-1, id, 0);
        return Dictionary.dictIdToString((byte[])id, (int)0, (int)id.length);
    }

    public static enum FilterConstantsTreatment {
        AS_IT_IS,
        REPLACE_WITH_GLOBAL_DICT,
        REPLACE_WITH_LOCAL_DICT;

    }
}

