/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer;

import java.util.Arrays;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.ObserverAggregators;
import org.junit.Assert;
import org.junit.Test;

public class RowAggregatorsTest {
    @Test
    public void testSerialize() {
        ObserverAggregators.HCol[] hcols = new ObserverAggregators.HCol[]{RowAggregatorsTest.newHCol("f", "c1", new String[]{"SUM", "COUNT"}, new String[]{"decimal", "long"}), RowAggregatorsTest.newHCol("f", "c2", new String[]{"SUM", "SUM"}, new String[]{"long", "long"})};
        ObserverAggregators sample = new ObserverAggregators(hcols);
        byte[] bytes = ObserverAggregators.serialize((ObserverAggregators)sample);
        ObserverAggregators copy = ObserverAggregators.deserialize((byte[])bytes);
        Assert.assertTrue((sample.nHCols == copy.nHCols ? 1 : 0) != 0);
        Assert.assertTrue((sample.nTotalMeasures == copy.nTotalMeasures ? 1 : 0) != 0);
        RowAggregatorsTest.assertEquals(sample.hcols[0], copy.hcols[0]);
        RowAggregatorsTest.assertEquals(sample.hcols[1], copy.hcols[1]);
    }

    private static ObserverAggregators.HCol newHCol(String family, String qualifier, String[] funcNames, String[] dataTypes) {
        return new ObserverAggregators.HCol(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier), funcNames, dataTypes);
    }

    private static void assertEquals(ObserverAggregators.HCol a, ObserverAggregators.HCol b) {
        Assert.assertTrue((a.nMeasures == b.nMeasures ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Arrays.equals(a.family, b.family));
        Assert.assertTrue((boolean)Arrays.equals(a.qualifier, b.qualifier));
        Assert.assertTrue((boolean)Arrays.equals(a.funcNames, b.funcNames));
        Assert.assertTrue((boolean)Arrays.equals(a.dataTypes, b.dataTypes));
    }
}

