/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.hbase.cube.v1.CubeStorageQuery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MeasureTypeOnlyAggrInBaseTest
extends LocalFileMetadataTestCase {
    private CubeInstance cube;
    private CubeDesc cubeDesc;
    private Set<TblColRef> dimensions;
    private List<FunctionDesc> metrics;

    public CubeManager getCubeManager() {
        return CubeManager.getInstance((KylinConfig)MeasureTypeOnlyAggrInBaseTest.getTestConfig());
    }

    private CubeInstance getTestKylinCubeWithSeller() {
        return this.getCubeManager().getCube("test_kylin_cube_with_slr_empty");
    }

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata();
        MetadataManager.clearCache();
        this.cube = this.getTestKylinCubeWithSeller();
        this.cubeDesc = this.cube.getDescriptor();
        this.dimensions = Sets.newHashSet();
        this.metrics = Lists.newArrayList();
        for (MeasureDesc measureDesc : this.cubeDesc.getMeasures()) {
            Collections.addAll(this.metrics, measureDesc.getFunction());
        }
        FunctionDesc mockUpFuncDesc = new FunctionDesc();
        Field field = FunctionDesc.class.getDeclaredField("measureType");
        field.setAccessible(true);
        field.set(mockUpFuncDesc, (Object)new MockUpMeasureType());
        this.metrics.add(mockUpFuncDesc);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testIdentifyCuboidV1() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException {
        CubeStorageQuery query = new CubeStorageQuery(this.cube);
        long baseCuboidId = this.cubeDesc.getRowkey().getFullMask();
        Method method = query.getClass().getDeclaredMethod("identifyCuboid", Set.class, Collection.class);
        method.setAccessible(true);
        Object ret = method.invoke((Object)query, Sets.newHashSet(), Lists.newArrayList());
        Assert.assertTrue((boolean)(ret instanceof Cuboid));
        Assert.assertNotEquals((long)baseCuboidId, (long)((Cuboid)ret).getId());
        ret = method.invoke((Object)query, this.dimensions, this.metrics);
        Assert.assertEquals((long)baseCuboidId, (long)((Cuboid)ret).getId());
    }

    @Test
    public void testIdentifyCuboidV2() throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException {
        CubeDesc cubeDesc = this.cube.getDescriptor();
        Cuboid ret = Cuboid.identifyCuboid((CubeDesc)cubeDesc, (Set)Sets.newHashSet(), (Collection)Lists.newArrayList());
        long baseCuboidId = cubeDesc.getRowkey().getFullMask();
        Assert.assertNotEquals((long)baseCuboidId, (long)ret.getId());
        ret = Cuboid.identifyCuboid((CubeDesc)cubeDesc, this.dimensions, this.metrics);
        Assert.assertEquals((long)baseCuboidId, (long)ret.getId());
    }

    class MockUpMeasureType
    extends MeasureType<String> {
        MockUpMeasureType() {
        }

        public MeasureIngester<String> newIngester() {
            return null;
        }

        public MeasureAggregator<String> newAggregator() {
            return null;
        }

        public boolean needRewrite() {
            return false;
        }

        public Class<?> getRewriteCalciteAggrFunctionClass() {
            return null;
        }

        public boolean onlyAggrInBaseCuboid() {
            return true;
        }
    }
}

