/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1.filter;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.kylin.storage.hbase.cube.v1.filter.FuzzyRowFilterV2;
import org.junit.Assert;
import org.junit.Test;

public class TestFuzzyRowFilterV2 {
    @Test
    public void testSatisfiesNoUnsafeForward() {
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.YES, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, -128, 1, 0, 1}, (int)0, (int)5, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, -128, 2, 0, 1}, (int)0, (int)5, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.YES, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, 2, 1, 3, 3}, (int)0, (int)5, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, 1, 1, 3, 0}, (int)0, (int)5, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, 1, 1, 3, 0}, (int)0, (int)5, (byte[])new byte[]{1, -11, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)false, (byte[])new byte[]{1, 2, 1, 0, 1}, (int)0, (int)5, (byte[])new byte[]{0, 1, 2}, (byte[])new byte[]{1, 0, 0}));
    }

    @Test
    public void testSatisfiesForward() {
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.YES, (Object)FuzzyRowFilterV2.satisfies((boolean)false, (byte[])new byte[]{1, -128, 1, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfies((boolean)false, (byte[])new byte[]{1, -128, 2, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.YES, (Object)FuzzyRowFilterV2.satisfies((boolean)false, (byte[])new byte[]{1, 2, 1, 3, 3}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfies((boolean)false, (byte[])new byte[]{1, 1, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfies((boolean)false, (byte[])new byte[]{1, 1, 1, 3, 0}, (byte[])new byte[]{1, -11, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfies((boolean)false, (byte[])new byte[]{1, 2, 1, 0, 1}, (byte[])new byte[]{0, 1, 2}, (byte[])new byte[]{0, -1, -1}));
    }

    @Test
    public void testSatisfiesReverse() {
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.YES, (Object)FuzzyRowFilterV2.satisfies((boolean)true, (byte[])new byte[]{1, -128, 1, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfies((boolean)true, (byte[])new byte[]{1, -128, 2, 0, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfies((boolean)true, (byte[])new byte[]{2, 3, 1, 1, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.YES, (Object)FuzzyRowFilterV2.satisfies((boolean)true, (byte[])new byte[]{1, 2, 1, 3, 3}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfies((boolean)true, (byte[])new byte[]{1, -11, 1, 3, 0}, (byte[])new byte[]{1, 1, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfies((boolean)true, (byte[])new byte[]{1, 3, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfies((boolean)true, (byte[])new byte[]{2, 1, 1, 1, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfies((boolean)true, (byte[])new byte[]{1, 2, 1, 0, 1}, (byte[])new byte[]{0, 1, 2}, (byte[])new byte[]{0, -1, -1}));
    }

    @Test
    public void testSatisfiesNoUnsafeReverse() {
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.YES, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, -128, 1, 0, 1}, (int)0, (int)5, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, -128, 2, 0, 1}, (int)0, (int)5, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{2, 3, 1, 1, 1}, (int)0, (int)5, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.YES, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, 2, 1, 3, 3}, (int)0, (int)5, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, -11, 1, 3, 0}, (int)0, (int)5, (byte[])new byte[]{1, 1, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, 3, 1, 3, 0}, (int)0, (int)5, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{2, 1, 1, 1, 0}, (int)0, (int)5, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{0, 0, 1, 0}));
        Assert.assertEquals((Object)FuzzyRowFilterV2.SatisfiesCode.NEXT_EXISTS, (Object)FuzzyRowFilterV2.satisfiesNoUnsafe((boolean)true, (byte[])new byte[]{1, 2, 1, 0, 1}, (int)0, (int)5, (byte[])new byte[]{0, 1, 2}, (byte[])new byte[]{1, 0, 0}));
    }

    @Test
    public void testGetNextForFuzzyRuleForward() {
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{0, 1, 2}, new byte[]{0, -1, -1}, new byte[]{1, 2, 1, 0, 1}, new byte[]{2, 1, 2, 0, 0});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{0, 1, 2}, new byte[]{0, -1, -1}, new byte[]{1, 1, 2, 0, 1}, new byte[]{1, 1, 2, 0, 2});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{0, 1, 0, 2, 0}, new byte[]{0, -1, 0, -1, 0}, new byte[]{1, 0, 2, 0, 1}, new byte[]{1, 1, 0, 2, 0});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{1, -128, 2, 0, 1}, new byte[]{1, -127, 1, 0, 0});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 1}, new byte[]{5, 1, 1, 1});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 1, 1}, new byte[]{5, 1, 0, 1, 2});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{0, 1, 0, 0}, new byte[]{0, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 2});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, -1, 1}, new byte[]{6, 1, 0, 1});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, -1, 0}, new byte[]{5, 1, -1, 1});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{5, 1, 1, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 2});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{-1, -1, 0, 0}, new byte[]{1, 1, 2, 2}, new byte[]{1, 1, 2, 3});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{-1, -1, 0, 0}, new byte[]{1, 1, 3, 2}, new byte[]{1, 1, 3, 3});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 0, 0}, new byte[]{1, 1, 2, 3}, new byte[]{1, 1, 2, 4});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 0, 0}, new byte[]{1, 1, 3, 2}, new byte[]{1, 1, 3, 3});
        TestFuzzyRowFilterV2.assertNext(false, new byte[]{1, 1, 0, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{0, 1, 3, 2}, new byte[]{1, 1, 0, 0});
        Assert.assertNull((Object)FuzzyRowFilterV2.getNextForFuzzyRule((byte[])new byte[]{2, 3, 1, 1, 1}, (byte[])new byte[]{1, 0, 1}, (byte[])new byte[]{-1, 0, -1}));
        Assert.assertNull((Object)FuzzyRowFilterV2.getNextForFuzzyRule((byte[])new byte[]{1, -11, 1, 3, 0}, (byte[])new byte[]{1, 1, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertNull((Object)FuzzyRowFilterV2.getNextForFuzzyRule((byte[])new byte[]{1, 3, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
        Assert.assertNull((Object)FuzzyRowFilterV2.getNextForFuzzyRule((byte[])new byte[]{2, 1, 1, 1, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
    }

    @Test
    public void testGetNextForFuzzyRuleReverse() {
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{0, 1, 2}, new byte[]{0, -1, -1}, new byte[]{1, 2, 1, 0, 1}, new byte[]{1, 1, 2, -1, -1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{0, 1, 0, 2, 0}, new byte[]{0, -1, 0, -1, 0}, new byte[]{1, 2, 1, 3, 1}, new byte[]{1, 1, 0, 2, 0});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{1, -128, 2, 0, 1}, new byte[]{1, -128, 1, -1, -1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 2, 1}, new byte[]{5, 1, 0, 1, -1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{0, 1, 0, 0}, new byte[]{0, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 0});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 1}, new byte[]{4, 1, -1, 1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, -1, 0}, new byte[]{5, 1, -2, 1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{1, 1, 0, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{2, 1, 3, 2}, new byte[]{1, 1, 0, 0});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{2, 3, 1, 1, 1}, new byte[]{1, 0, 1, -1, -1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{1, 1, 0, 3}, new byte[]{-1, -1, 0, -1}, new byte[]{1, -11, 1, 3, 0}, new byte[]{1, 1, 0, 3, -1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1}, new byte[]{1, 3, 1, 3, 0}, new byte[]{1, 2, 0, 3, -1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{1, 2, 0, 3}, new byte[]{-1, -1, 0, -1}, new byte[]{2, 1, 1, 1, 0}, new byte[]{1, 2, 0, 3, -1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{1, 0, 1}, new byte[]{-1, 0, -1}, new byte[]{1, -128, 2}, new byte[]{1, -128, 1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{0, 1, 0, 1}, new byte[]{0, -1, 0, -1}, new byte[]{5, 1, 0, 2}, new byte[]{5, 1, 0, 1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{5, 1, 1, 0}, new byte[]{-1, -1, 0, 0}, new byte[]{5, 1, -1, 1}, new byte[]{5, 1, -1, 0});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{1, 1, 1, 1}, new byte[]{-1, -1, 0, 0}, new byte[]{1, 1, 2, 2}, new byte[]{1, 1, 2, 1});
        TestFuzzyRowFilterV2.assertNext(true, new byte[]{1, 1, 1, 1}, new byte[]{0, 0, 0, 0}, new byte[]{1, 1, 2, 3}, new byte[]{1, 1, 2, 2});
        Assert.assertNull((Object)FuzzyRowFilterV2.getNextForFuzzyRule((boolean)true, (byte[])new byte[]{1, 1, 1, 3, 0}, (byte[])new byte[]{1, 2, 0, 3}, (byte[])new byte[]{-1, -1, 0, -1}));
    }

    private static void assertNext(boolean reverse, byte[] fuzzyRow, byte[] mask, byte[] current, byte[] expected) {
        KeyValue kv = KeyValue.createFirstOnRow((byte[])current);
        byte[] nextForFuzzyRule = FuzzyRowFilterV2.getNextForFuzzyRule((boolean)reverse, (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])fuzzyRow, (byte[])mask);
        Assert.assertEquals((Object)Bytes.toStringBinary((byte[])expected), (Object)Bytes.toStringBinary((byte[])nextForFuzzyRule));
    }
}

