/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer;

import java.util.Arrays;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorRowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RowTypeTest
extends LocalFileMetadataTestCase {
    @Before
    public void setUp() throws Exception {
        this.createTestMetadata();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testSerialize() {
        CubeInstance cube = CubeManager.getInstance((KylinConfig)RowTypeTest.getTestConfig()).getCube("test_kylin_cube_without_slr_ready");
        CubeDesc cubeDesc = cube.getDescriptor();
        long baseCuboidId = Cuboid.getBaseCuboidId((CubeDesc)cubeDesc);
        Cuboid cuboid = Cuboid.findById((CubeDesc)cubeDesc, (long)baseCuboidId);
        CoprocessorRowType rowType = CoprocessorRowType.fromCuboid((CubeSegment)cube.getLatestReadySegment(), (Cuboid)cuboid);
        byte[] bytes = CoprocessorRowType.serialize((CoprocessorRowType)rowType);
        CoprocessorRowType copy = CoprocessorRowType.deserialize((byte[])bytes);
        Assert.assertTrue((boolean)Arrays.equals(rowType.columns, copy.columns));
        Assert.assertTrue((boolean)Arrays.equals(rowType.columnSizes, copy.columnSizes));
    }
}

