/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.metadata.filter.CaseTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.hbase.common.coprocessor.FilterBaseTest;
import org.junit.Test;

public class FilterSerializeTest
extends FilterBaseTest {
    @Test
    public void testSerialize01() {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildEQCompareFilter(groups, 0);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)filter, newFilter);
    }

    @Test
    public void testSerialize02() {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildEQCompareFilter(groups, 1);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)filter, newFilter);
    }

    @Test
    public void testSerialize03() {
        List<TblColRef> groups = this.buildGroups();
        TupleFilter filter = this.buildAndFilter(groups);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter(filter, newFilter);
    }

    @Test
    public void testSerialize04() {
        List<TblColRef> groups = this.buildGroups();
        TupleFilter filter = this.buildOrFilter(groups);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter(filter, newFilter);
    }

    @Test
    public void testSerialize05() {
        ColumnDesc column = new ColumnDesc();
        TblColRef colRef = column.getRef();
        ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
        groups.add(colRef);
        CompareTupleFilter filter = this.buildEQCompareFilter(groups, 0);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)filter, newFilter);
    }

    @Test
    public void testSerialize06() {
        ColumnDesc column = new ColumnDesc();
        column.setName("META_CATEG_NAME");
        TblColRef colRef = column.getRef();
        ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
        groups.add(colRef);
        CompareTupleFilter filter = this.buildEQCompareFilter(groups, 0);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)filter, newFilter);
    }

    @Test
    public void testSerialize07() {
        TableDesc table = new TableDesc();
        table.setName("TEST_KYLIN_FACT");
        table.setDatabase("DEFAULT");
        ColumnDesc column = new ColumnDesc();
        column.setTable(table);
        TblColRef colRef = column.getRef();
        ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
        groups.add(colRef);
        CompareTupleFilter filter = this.buildEQCompareFilter(groups, 0);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)filter, newFilter);
    }

    @Test
    public void testSerialize08() {
        TableDesc table = new TableDesc();
        table.setDatabase("DEFAULT");
        ColumnDesc column = new ColumnDesc();
        column.setTable(table);
        TblColRef colRef = column.getRef();
        ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
        groups.add(colRef);
        CompareTupleFilter filter = this.buildEQCompareFilter(groups, 0);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)filter, newFilter);
    }

    @Test
    public void testSerialize10() {
        List<TblColRef> groups = this.buildGroups();
        TupleFilter orFilter = this.buildOrFilter(groups);
        TupleFilter andFilter = this.buildAndFilter(groups);
        LogicalTupleFilter logicFilter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
        logicFilter.addChild(orFilter);
        logicFilter.addChild(andFilter);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)logicFilter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)logicFilter, newFilter);
    }

    @Test
    public void testSerialize11() {
        List<TblColRef> groups = this.buildGroups();
        TupleFilter orFilter = this.buildOrFilter(groups);
        TupleFilter andFilter = this.buildAndFilter(groups);
        LogicalTupleFilter logicFilter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.AND);
        logicFilter.addChild(orFilter);
        logicFilter.addChild(andFilter);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)logicFilter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)logicFilter, newFilter);
    }

    @Test
    public void testSerialize12() {
        List<TblColRef> groups = this.buildGroups();
        CaseTupleFilter filter = this.buildCaseFilter(groups);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)filter, newFilter);
    }

    @Test
    public void testSerialize13() {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildCompareCaseFilter(groups, "0");
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)filter, newFilter);
    }

    @Test
    public void testSerialize14() throws ParseException {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildINCompareFilter(groups.get(0));
        long start = System.currentTimeMillis();
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        System.out.println("Size of serialized filter " + bytes.length + ", serialize time: " + (System.currentTimeMillis() - start));
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)filter, newFilter);
    }

    @Test
    public void testDynamic() {
        CompareTupleFilter compareDynamicFilter = this.buildCompareDynamicFilter(this.buildGroups());
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)compareDynamicFilter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        bytes = TupleFilterSerializer.serialize((TupleFilter)newFilter, (IFilterCodeSystem)CS);
        TupleFilter newFilter2 = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        this.compareFilter((TupleFilter)compareDynamicFilter, newFilter);
        this.compareFilter((TupleFilter)compareDynamicFilter, newFilter2);
    }
}

