/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrphanHBaseCleanJob
extends AbstractApplication {
    private static final Option OPTION_DELETE;
    private static final Option OPTION_WHITELIST;
    protected static final Logger logger;
    boolean delete = false;
    Set<String> metastoreWhitelistSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    private void cleanUnusedHBaseTables(Configuration conf) throws IOException {
        HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
        String tableNamePrefix = "KYLIN_";
        HTableDescriptor[] tableDescriptors = hbaseAdmin.listTables(tableNamePrefix + ".*");
        ArrayList<String> allTablesNeedToBeDropped = new ArrayList<String>();
        for (HTableDescriptor desc : tableDescriptors) {
            String host = desc.getValue("KYLIN_HOST");
            if (!this.metastoreWhitelistSet.contains(host)) {
                logger.info("HTable {} is recognized as orphan because its tag is {}", (Object)desc.getTableName(), (Object)host);
                allTablesNeedToBeDropped.add(desc.getTableName().getNameAsString());
                continue;
            }
            logger.info("HTable {} belongs to {}", (Object)desc.getTableName(), (Object)host);
        }
        if (this.delete) {
            for (String htableName : allTablesNeedToBeDropped) {
                logger.info("Deleting HBase table " + htableName);
                if (hbaseAdmin.tableExists(htableName)) {
                    if (hbaseAdmin.isTableEnabled(htableName)) {
                        hbaseAdmin.disableTable(htableName);
                    }
                    hbaseAdmin.deleteTable(htableName);
                    logger.info("Deleted HBase table " + htableName);
                    continue;
                }
                logger.info("HBase table" + htableName + " does not exist");
            }
        } else {
            System.out.println("--------------- Tables To Be Dropped ---------------");
            for (String htableName : allTablesNeedToBeDropped) {
                System.out.println(htableName);
            }
            System.out.println("----------------------------------------------------");
        }
        hbaseAdmin.close();
    }

    public static void main(String[] args) throws Exception {
        OrphanHBaseCleanJob job = new OrphanHBaseCleanJob();
        job.execute(args);
    }

    @Override
    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DELETE);
        options.addOption(OPTION_WHITELIST);
        return options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String[] metastoreWhitelist;
        logger.info("options: '" + optionsHelper.getOptionsAsString() + "'");
        logger.info("delete option value: '" + optionsHelper.getOptionValue(OPTION_DELETE) + "'");
        this.delete = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_DELETE));
        for (String ms : metastoreWhitelist = optionsHelper.getOptionValue(OPTION_WHITELIST).split(",")) {
            logger.info("metadata store in white list: " + ms);
            this.metastoreWhitelistSet.add(ms);
        }
        Configuration conf = HBaseConfiguration.create();
        this.cleanUnusedHBaseTables(conf);
    }

    static {
        OptionBuilder.withArgName((String)"delete");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Delete the unused storage");
        OPTION_DELETE = OptionBuilder.create((String)"delete");
        OptionBuilder.withArgName((String)"whitelist");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"metadata store whitelist, separated with comma");
        OPTION_WHITELIST = OptionBuilder.create((String)"whitelist");
        logger = LoggerFactory.getLogger(OrphanHBaseCleanJob.class);
    }
}

