/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.io.Text;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.measure.BufferedMeasureEncoder;
import org.apache.kylin.metadata.model.MeasureDesc;

public class KeyValueCreator {
    byte[] cfBytes;
    byte[] qBytes;
    long timestamp;
    int[] refIndex;
    MeasureDesc[] refMeasures;
    BufferedMeasureEncoder codec;
    Object[] colValues;
    public boolean isFullCopy;

    public KeyValueCreator(CubeDesc cubeDesc, HBaseColumnDesc colDesc) {
        this.cfBytes = Bytes.toBytes(colDesc.getColumnFamilyName());
        this.qBytes = Bytes.toBytes(colDesc.getQualifier());
        this.timestamp = 0L;
        this.refIndex = colDesc.getMeasureIndex();
        this.refMeasures = colDesc.getMeasures();
        this.codec = new BufferedMeasureEncoder(this.refMeasures);
        this.colValues = new Object[this.refMeasures.length];
        this.isFullCopy = true;
        List<MeasureDesc> measures = cubeDesc.getMeasures();
        for (int i = 0; i < measures.size(); ++i) {
            if (this.refIndex.length > i && this.refIndex[i] == i) continue;
            this.isFullCopy = false;
        }
    }

    public KeyValue create(Text key, Object[] measureValues) {
        return this.create(key.getBytes(), 0, key.getLength(), measureValues);
    }

    public KeyValue create(byte[] keyBytes, int keyOffset, int keyLength, Object[] measureValues) {
        for (int i = 0; i < this.colValues.length; ++i) {
            this.colValues[i] = measureValues[this.refIndex[i]];
        }
        ByteBuffer valueBuf = this.codec.encode(this.colValues);
        return this.create(keyBytes, keyOffset, keyLength, valueBuf.array(), 0, valueBuf.position());
    }

    public KeyValue create(byte[] keyBytes, int keyOffset, int keyLength, byte[] value, int voffset, int vlen) {
        return new KeyValue(keyBytes, keyOffset, keyLength, this.cfBytes, 0, this.cfBytes.length, this.qBytes, 0, this.qBytes.length, this.timestamp, KeyValue.Type.Put, value, voffset, vlen);
    }

    public KeyValue create(Text key, byte[] value, int voffset, int vlen) {
        return this.create(key.getBytes(), 0, key.getLength(), value, voffset, vlen);
    }
}

