/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.ISegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.FuzzyKeyEncoder;
import org.apache.kylin.cube.kv.FuzzyMaskEncoder;
import org.apache.kylin.cube.kv.LazyRowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.cube.model.HBaseMappingDesc;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRange;
import org.apache.kylin.gridtable.IGTStorage;
import org.apache.kylin.storage.hbase.cube.v2.RawScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CubeHBaseRPC
implements IGTStorage {
    public static final Logger logger = LoggerFactory.getLogger(CubeHBaseRPC.class);
    protected final CubeSegment cubeSeg;
    protected final Cuboid cuboid;
    protected final GTInfo fullGTInfo;
    private final RowKeyEncoder fuzzyKeyEncoder;
    private final RowKeyEncoder fuzzyMaskEncoder;

    public CubeHBaseRPC(ISegment segment, Cuboid cuboid, GTInfo fullGTInfo) {
        Preconditions.checkArgument((boolean)(segment instanceof CubeSegment), (Object)"segment must be CubeSegment");
        this.cubeSeg = (CubeSegment)segment;
        this.cuboid = cuboid;
        this.fullGTInfo = fullGTInfo;
        this.fuzzyKeyEncoder = new FuzzyKeyEncoder(this.cubeSeg, cuboid);
        this.fuzzyMaskEncoder = new FuzzyMaskEncoder(this.cubeSeg, cuboid);
    }

    public static Scan buildScan(RawScan rawScan) {
        Scan scan = new Scan();
        scan.setCaching(rawScan.hbaseCaching);
        scan.setMaxResultSize((long)rawScan.hbaseMaxResultSize);
        scan.setCacheBlocks(true);
        scan.setAttribute("scan.attributes.metrics.enable", Bytes.toBytes(Boolean.TRUE));
        if (rawScan.startKey != null) {
            scan.setStartRow(rawScan.startKey);
        }
        if (rawScan.endKey != null) {
            scan.setStopRow(rawScan.endKey);
        }
        if (rawScan.fuzzyKeys != null) {
            CubeHBaseRPC.applyFuzzyFilter(scan, rawScan.fuzzyKeys);
        }
        if (rawScan.hbaseColumns != null) {
            CubeHBaseRPC.applyHBaseColums(scan, rawScan.hbaseColumns);
        }
        return scan;
    }

    private RawScan preparedHBaseScan(GTRecord pkStart, GTRecord pkEnd, List<GTRecord> fuzzyKeys, ImmutableBitSet selectedColBlocks) {
        List<Pair<byte[], byte[]>> selectedColumns = this.makeHBaseColumns(selectedColBlocks);
        LazyRowKeyEncoder encoder = new LazyRowKeyEncoder(this.cubeSeg, this.cuboid);
        byte[] start = encoder.createBuf();
        byte[] end = encoder.createBuf();
        encoder.setBlankByte((byte)0);
        encoder.encode(pkStart, pkStart.getInfo().getPrimaryKey(), start);
        encoder.setBlankByte((byte)-1);
        encoder.encode(pkEnd, pkEnd.getInfo().getPrimaryKey(), end);
        byte[] temp = new byte[end.length + 1];
        System.arraycopy(end, 0, temp, 0, end.length);
        end = temp;
        List<Pair<byte[], byte[]>> hbaseFuzzyKeys = this.translateFuzzyKeys(fuzzyKeys);
        KylinConfig config = this.cubeSeg.getCubeDesc().getConfig();
        int hbaseCaching = config.getHBaseScanCacheRows();
        int hbaseMaxResultSize = config.getHBaseScanMaxResultSize();
        return new RawScan(start, end, selectedColumns, hbaseFuzzyKeys, hbaseCaching, hbaseMaxResultSize);
    }

    protected List<RawScan> preparedHBaseScans(List<GTScanRange> ranges, ImmutableBitSet selectedColBlocks) {
        ArrayList allRawScans = Lists.newArrayList();
        for (GTScanRange range : ranges) {
            allRawScans.add(this.preparedHBaseScan(range.pkStart, range.pkEnd, range.fuzzyKeys, selectedColBlocks));
        }
        return allRawScans;
    }

    private boolean isMemoryHungry(ImmutableBitSet selectedColBlocks) {
        ImmutableBitSet selectColumns = this.fullGTInfo.selectColumns(selectedColBlocks);
        return this.fullGTInfo.getMaxColumnLength(selectColumns) > 1024;
    }

    private List<Pair<byte[], byte[]>> translateFuzzyKeys(List<GTRecord> fuzzyKeys) {
        if (fuzzyKeys == null || fuzzyKeys.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList ret = Lists.newArrayList();
        for (GTRecord gtRecordFuzzyKey : fuzzyKeys) {
            byte[] hbaseFuzzyKey = this.fuzzyKeyEncoder.createBuf();
            byte[] hbaseFuzzyMask = this.fuzzyMaskEncoder.createBuf();
            this.fuzzyKeyEncoder.encode(gtRecordFuzzyKey, gtRecordFuzzyKey.getInfo().getPrimaryKey(), hbaseFuzzyKey);
            this.fuzzyMaskEncoder.encode(gtRecordFuzzyKey, gtRecordFuzzyKey.getInfo().getPrimaryKey(), hbaseFuzzyMask);
            ret.add(Pair.newPair(hbaseFuzzyKey, hbaseFuzzyMask));
        }
        return ret;
    }

    protected List<Pair<byte[], byte[]>> makeHBaseColumns(ImmutableBitSet selectedColBlocks) {
        ArrayList result = Lists.newArrayList();
        int colBlkIndex = 1;
        HBaseMappingDesc hbaseMapping = this.cubeSeg.getCubeDesc().getHbaseMapping();
        for (HBaseColumnFamilyDesc familyDesc : hbaseMapping.getColumnFamily()) {
            byte[] byteFamily = Bytes.toBytes(familyDesc.getName());
            for (HBaseColumnDesc hbaseColDesc : familyDesc.getColumns()) {
                if (selectedColBlocks.get(colBlkIndex)) {
                    byte[] byteQualifier = Bytes.toBytes(hbaseColDesc.getQualifier());
                    result.add(Pair.newPair(byteFamily, byteQualifier));
                }
                ++colBlkIndex;
            }
        }
        return result;
    }

    protected List<List<Integer>> getHBaseColumnsGTMapping(ImmutableBitSet selectedColBlocks) {
        ArrayList ret = Lists.newArrayList();
        int colBlkIndex = 1;
        int metricOffset = this.fullGTInfo.getPrimaryKey().trueBitCount();
        HBaseMappingDesc hbaseMapping = this.cubeSeg.getCubeDesc().getHbaseMapping();
        for (HBaseColumnFamilyDesc familyDesc : hbaseMapping.getColumnFamily()) {
            for (HBaseColumnDesc hbaseColDesc : familyDesc.getColumns()) {
                if (selectedColBlocks.get(colBlkIndex)) {
                    int[] metricIndexes = hbaseColDesc.getMeasureIndex();
                    Integer[] gtIndexes = new Integer[metricIndexes.length];
                    for (int i = 0; i < gtIndexes.length; ++i) {
                        gtIndexes[i] = metricIndexes[i] + metricOffset;
                    }
                    ret.add(Arrays.asList(gtIndexes));
                }
                ++colBlkIndex;
            }
        }
        Preconditions.checkState((selectedColBlocks.trueBitCount() == ret.size() + 1 ? 1 : 0) != 0);
        return ret;
    }

    public static void applyHBaseColums(Scan scan, List<Pair<byte[], byte[]>> hbaseColumns) {
        for (Pair<byte[], byte[]> hbaseColumn : hbaseColumns) {
            byte[] byteFamily = hbaseColumn.getFirst();
            byte[] byteQualifier = hbaseColumn.getSecond();
            scan.addColumn(byteFamily, byteQualifier);
        }
    }

    public static void applyFuzzyFilter(Scan scan, List<Pair<byte[], byte[]>> fuzzyKeys) {
        if (fuzzyKeys != null && fuzzyKeys.size() > 0) {
            FuzzyRowFilter rowFilter = new FuzzyRowFilter(CubeHBaseRPC.convertToHBasePair(fuzzyKeys));
            Filter filter = scan.getFilter();
            if (filter != null) {
                FilterList filterList = new FilterList(new Filter[0]);
                filterList.addFilter(filter);
                filterList.addFilter((Filter)rowFilter);
                scan.setFilter((Filter)filterList);
            } else {
                scan.setFilter((Filter)rowFilter);
            }
        }
    }

    private static List<org.apache.hadoop.hbase.util.Pair<byte[], byte[]>> convertToHBasePair(List<Pair<byte[], byte[]>> pairList) {
        ArrayList result = Lists.newArrayList();
        for (Pair<byte[], byte[]> pair : pairList) {
            org.apache.hadoop.hbase.util.Pair element = new org.apache.hadoop.hbase.util.Pair((Object)pair.getFirst(), (Object)pair.getSecond());
            result.add(element);
        }
        return result;
    }

    protected void logScan(RawScan rawScan, String tableName) {
        StringBuilder info = new StringBuilder();
        info.append("Visiting hbase table ").append(tableName).append(": ");
        if (this.cuboid.requirePostAggregation()) {
            info.append("cuboid require post aggregation, from ");
        } else {
            info.append("cuboid exact match, from ");
        }
        info.append(this.cuboid.getInputID());
        info.append(" to ");
        info.append(this.cuboid.getId());
        info.append(" Start: ");
        info.append(rawScan.getStartKeyAsString());
        info.append(" (");
        info.append(Bytes.toStringBinary(rawScan.startKey) + ")");
        info.append(" Stop:  ");
        info.append(rawScan.getEndKeyAsString());
        info.append(" (");
        info.append(Bytes.toStringBinary(rawScan.endKey) + ")");
        if (rawScan.fuzzyKeys != null && rawScan.fuzzyKeys.size() != 0) {
            info.append(" Fuzzy key counts: " + rawScan.fuzzyKeys.size());
            info.append(". Fuzzy keys : ");
            info.append(rawScan.getFuzzyKeyAsString());
        } else {
            info.append(", No Fuzzy Key");
        }
        logger.info(info.toString());
    }
}

