/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.regionserver.RegionScanner;

public class ResultScannerAdapter
implements ResultScanner {
    private RegionScanner scanner;

    public ResultScannerAdapter(RegionScanner scanner) {
        this.scanner = scanner;
    }

    public Iterator<Result> iterator() {
        return new Iterator<Result>(){
            Result next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = ResultScannerAdapter.this.next();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.next != null;
            }

            @Override
            public Result next() {
                Result r = this.next;
                this.next = null;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Result next() throws IOException {
        ArrayList cells = Lists.newArrayList();
        this.scanner.next((List)cells);
        if (cells.isEmpty()) {
            return null;
        }
        return Result.create((List)cells);
    }

    public Result[] next(int nbRows) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() {
        try {
            this.scanner.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

