/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.StorageException;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.hbase.cube.v1.CubeTupleConverter;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.ObserverEnabler;
import org.apache.kylin.storage.hbase.cube.v1.filter.FuzzyRowFilterV2;
import org.apache.kylin.storage.hbase.steps.RowValueDecoder;
import org.apache.kylin.storage.translate.HBaseKeyRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeSegmentTupleIterator
implements ITupleIterator {
    public static final Logger logger = LoggerFactory.getLogger(CubeSegmentTupleIterator.class);
    protected final CubeSegment cubeSeg;
    private final TupleFilter filter;
    private final Collection<TblColRef> groupBy;
    protected final List<RowValueDecoder> rowValueDecoders;
    private final StorageContext context;
    private final String tableName;
    private final HTableInterface table;
    protected CubeTupleConverter tupleConverter;
    protected final Iterator<HBaseKeyRange> rangeIterator;
    protected final Tuple oneTuple;
    private Scan scan;
    private ResultScanner scanner;
    protected Iterator<Result> resultIterator;
    protected int scanCount;
    protected int scanCountDelta;
    protected Tuple next;
    protected final Cuboid cuboid;
    private List<MeasureType.IAdvMeasureFiller> advMeasureFillers;
    private int advMeasureRowsRemaining;
    private int advMeasureRowIndex;

    public CubeSegmentTupleIterator(CubeSegment cubeSeg, List<HBaseKeyRange> keyRanges, HConnection conn, Set<TblColRef> dimensions, TupleFilter filter, Set<TblColRef> groupBy, List<RowValueDecoder> rowValueDecoders, StorageContext context, TupleInfo returnTupleInfo) {
        this.cubeSeg = cubeSeg;
        this.filter = filter;
        this.groupBy = groupBy;
        this.rowValueDecoders = rowValueDecoders;
        this.context = context;
        this.tableName = cubeSeg.getStorageLocationIdentifier();
        this.cuboid = keyRanges.get(0).getCuboid();
        for (HBaseKeyRange range : keyRanges) {
            assert (this.cuboid.equals(range.getCuboid()));
        }
        this.tupleConverter = new CubeTupleConverter(cubeSeg, this.cuboid, rowValueDecoders, returnTupleInfo);
        this.oneTuple = new Tuple(returnTupleInfo);
        this.rangeIterator = keyRanges.iterator();
        try {
            this.table = conn.getTable(this.tableName);
        }
        catch (Throwable t) {
            throw new StorageException("Error when open connection to table " + this.tableName, t);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.advMeasureRowsRemaining > 0) {
            for (MeasureType.IAdvMeasureFiller filler : this.advMeasureFillers) {
                filler.fillTuple(this.oneTuple, this.advMeasureRowIndex);
            }
            ++this.advMeasureRowIndex;
            --this.advMeasureRowsRemaining;
            this.next = this.oneTuple;
            return true;
        }
        if (this.resultIterator == null) {
            if (!this.rangeIterator.hasNext()) {
                return false;
            }
            this.resultIterator = this.doScan(this.rangeIterator.next());
        }
        if (!this.resultIterator.hasNext()) {
            this.closeScanner();
            this.resultIterator = null;
            return this.hasNext();
        }
        Result result = this.resultIterator.next();
        ++this.scanCount;
        if (++this.scanCountDelta >= 1000) {
            this.flushScanCountDelta();
        }
        this.advMeasureFillers = this.tupleConverter.translateResult(result, this.oneTuple);
        if (this.advMeasureFillers == null) {
            this.next = this.oneTuple;
            return true;
        }
        this.advMeasureRowsRemaining = -1;
        for (MeasureType.IAdvMeasureFiller filler : this.advMeasureFillers) {
            if (this.advMeasureRowsRemaining < 0) {
                this.advMeasureRowsRemaining = filler.getNumOfRows();
            }
            if (this.advMeasureRowsRemaining == filler.getNumOfRows()) continue;
            throw new IllegalStateException();
        }
        if (this.advMeasureRowsRemaining < 0) {
            throw new IllegalStateException();
        }
        this.advMeasureRowIndex = 0;
        return this.hasNext();
    }

    @Override
    public Tuple next() {
        if (this.next == null) {
            this.hasNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
        }
        Tuple r = this.next;
        this.next = null;
        return r;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected final Iterator<Result> doScan(HBaseKeyRange keyRange) {
        Iterator iter = null;
        try {
            this.scan = this.buildScan(keyRange);
            this.applyFuzzyFilter(this.scan, keyRange);
            this.logScan(keyRange);
            this.scanner = ObserverEnabler.scanWithCoprocessorIfBeneficial(this.cubeSeg, keyRange.getCuboid(), this.filter, this.groupBy, this.rowValueDecoders, this.context, this.table, this.scan);
            iter = this.scanner.iterator();
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error when scan from lower key {1} to upper key {2} on table {0}.", this.tableName, Bytes.toString(keyRange.getStartKey()), Bytes.toString(keyRange.getStopKey()));
            throw new StorageException(msg, t);
        }
        return iter;
    }

    private void logScan(HBaseKeyRange keyRange) {
        StringBuilder info = new StringBuilder();
        info.append("Scan hbase table ").append(this.tableName).append(": ");
        if (keyRange.getCuboid().requirePostAggregation()) {
            info.append(" cuboid require post aggregation, from ");
        } else {
            info.append(" cuboid exact match, from ");
        }
        info.append(keyRange.getCuboid().getInputID());
        info.append(" to ");
        info.append(keyRange.getCuboid().getId());
        info.append(" Start: ");
        info.append(keyRange.getStartKeyAsString());
        info.append(" - ");
        info.append(Bytes.toStringBinary(keyRange.getStartKey()));
        info.append(" Stop:  ");
        info.append(keyRange.getStopKeyAsString());
        info.append(" - ");
        info.append(Bytes.toStringBinary(keyRange.getStopKey()));
        if (this.scan.getFilter() != null) {
            info.append(" Fuzzy key counts: " + keyRange.getFuzzyKeys().size());
            info.append(" Fuzzy: ");
            info.append(keyRange.getFuzzyKeyAsString());
        }
        logger.info(info.toString());
    }

    private Scan buildScan(HBaseKeyRange keyRange) {
        Scan scan = new Scan();
        this.tuneScanParameters(scan);
        scan.setAttribute("scan.attributes.metrics.enable", Bytes.toBytes(Boolean.TRUE));
        for (RowValueDecoder valueDecoder : this.rowValueDecoders) {
            HBaseColumnDesc hbaseColumn = valueDecoder.getHBaseColumn();
            byte[] byteFamily = Bytes.toBytes(hbaseColumn.getColumnFamilyName());
            byte[] byteQualifier = Bytes.toBytes(hbaseColumn.getQualifier());
            scan.addColumn(byteFamily, byteQualifier);
        }
        scan.setStartRow(keyRange.getStartKey());
        scan.setStopRow(keyRange.getStopKey());
        return scan;
    }

    private void tuneScanParameters(Scan scan) {
        KylinConfig config = this.cubeSeg.getCubeDesc().getConfig();
        scan.setCaching(config.getHBaseScanCacheRows());
        scan.setMaxResultSize((long)config.getHBaseScanMaxResultSize());
        scan.setCacheBlocks(true);
    }

    private void applyFuzzyFilter(Scan scan, HBaseKeyRange keyRange) {
        List fuzzyKeys = keyRange.getFuzzyKeys();
        if (fuzzyKeys != null && fuzzyKeys.size() > 0) {
            boolean useFuzzyRowFilterV2 = false;
            FuzzyRowFilterV2 fuzzyFilter = null;
            fuzzyFilter = useFuzzyRowFilterV2 ? new FuzzyRowFilterV2(this.convertToHBasePair(fuzzyKeys)) : new FuzzyRowFilter(this.convertToHBasePair(fuzzyKeys));
            Filter filter = scan.getFilter();
            if (filter != null) {
                throw new RuntimeException("Scan filter not empty : " + filter);
            }
            scan.setFilter((Filter)fuzzyFilter);
        }
    }

    private List<org.apache.hadoop.hbase.util.Pair<byte[], byte[]>> convertToHBasePair(List<Pair<byte[], byte[]>> pairList) {
        ArrayList result = Lists.newArrayList();
        for (Pair<byte[], byte[]> pair : pairList) {
            org.apache.hadoop.hbase.util.Pair element = new org.apache.hadoop.hbase.util.Pair((Object)pair.getFirst(), (Object)pair.getSecond());
            result.add(element);
        }
        return result;
    }

    protected void closeScanner() {
        this.flushScanCountDelta();
        if (logger.isDebugEnabled() && this.scan != null) {
            byte[] metricsBytes = this.scan.getAttribute("scan.attributes.metrics.data");
            if (metricsBytes != null) {
                ScanMetrics scanMetrics = ProtobufUtil.toScanMetrics((byte[])metricsBytes);
                logger.debug("HBase Metrics when scanning " + this.tableName + " count={}, ms={}, bytes={}, remote_bytes={}, regions={}, not_serving_region={}, rpc={}, rpc_retries={}, remote_rpc={}, remote_rpc_retries={}", new Object[]{this.scanCount, scanMetrics.sumOfMillisSecBetweenNexts, scanMetrics.countOfBytesInResults, scanMetrics.countOfBytesInRemoteResults, scanMetrics.countOfRegions, scanMetrics.countOfNSRE, scanMetrics.countOfRPCcalls, scanMetrics.countOfRPCRetries, scanMetrics.countOfRemoteRPCcalls, scanMetrics.countOfRemoteRPCRetries});
            }
            this.scan = null;
        }
        try {
            if (this.scanner != null) {
                this.scanner.close();
                this.scanner = null;
            }
        }
        catch (Throwable t) {
            throw new StorageException("Error when close scanner for table " + this.tableName, t);
        }
    }

    private void closeTable() {
        try {
            if (this.table != null) {
                this.table.close();
            }
        }
        catch (Throwable t) {
            throw new StorageException("Error when close table " + this.tableName, t);
        }
    }

    @Override
    public void close() {
        logger.info("Closing CubeSegmentTupleIterator");
        this.closeScanner();
        this.closeTable();
    }

    protected void flushScanCountDelta() {
        this.context.increaseTotalScanCount((long)this.scanCountDelta);
        this.scanCountDelta = 0;
    }
}

