/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import java.util.Collection;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class SQLDigest {
    public String factTable;
    public TupleFilter filter;
    public Collection<JoinDesc> joinDescs;
    public Collection<TblColRef> allColumns;
    public Collection<TblColRef> groupbyColumns;
    public Collection<TblColRef> filterColumns;
    public Collection<TblColRef> metricColumns;
    public Collection<FunctionDesc> aggregations;
    public Collection<MeasureDesc> sortMeasures;
    public Collection<OrderEnum> sortOrders;
    public boolean isRawQuery;

    public SQLDigest(String factTable, TupleFilter filter, Collection<JoinDesc> joinDescs, Collection<TblColRef> allColumns, Collection<TblColRef> groupbyColumns, Collection<TblColRef> filterColumns, Collection<TblColRef> aggregatedColumns, Collection<FunctionDesc> aggregateFunnc, Collection<MeasureDesc> sortMeasures, Collection<OrderEnum> sortOrders) {
        this.factTable = factTable;
        this.filter = filter;
        this.joinDescs = joinDescs;
        this.allColumns = allColumns;
        this.groupbyColumns = groupbyColumns;
        this.filterColumns = filterColumns;
        this.metricColumns = aggregatedColumns;
        this.aggregations = aggregateFunnc;
        this.sortMeasures = sortMeasures;
        this.sortOrders = sortOrders;
        this.isRawQuery = this.isRawQuery();
    }

    private boolean isRawQuery() {
        return this.groupbyColumns.isEmpty() && this.aggregations.isEmpty();
    }

    public String toString() {
        return "fact table " + this.factTable + "," + "group by " + this.groupbyColumns + "," + "filter on " + this.filterColumns + "," + "with aggregates" + this.aggregations + ".";
    }

    public static enum OrderEnum {
        ASCENDING,
        DESCENDING;

    }
}

