/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;

public class TblColRef
implements Serializable {
    private static final String INNER_TABLE_NAME = "_kylin_table";
    private ColumnDesc column;

    public static TblColRef newInnerColumn(String columnName, InnerDataTypeEnum dataType) {
        ColumnDesc column = new ColumnDesc();
        column.setName(columnName);
        TableDesc table = new TableDesc();
        column.setTable(table);
        TblColRef colRef = new TblColRef(column);
        colRef.markInnerColumn(dataType);
        return colRef;
    }

    TblColRef(ColumnDesc column) {
        this.column = column;
    }

    public ColumnDesc getColumnDesc() {
        return this.column;
    }

    public void setColumn(ColumnDesc column) {
        this.column = column;
    }

    public String getName() {
        return this.column.getName();
    }

    public String getTable() {
        if (this.column.getTable() == null) {
            return null;
        }
        return this.column.getTable().getIdentity();
    }

    public String getCanonicalName() {
        return this.getTable() + "." + this.getName();
    }

    public String getDatatype() {
        return this.column.getDatatype();
    }

    public DataType getType() {
        return this.column.getType();
    }

    public void markInnerColumn(InnerDataTypeEnum dataType) {
        this.column.setDatatype(dataType.getDataType());
        this.column.getTable().setName(INNER_TABLE_NAME);
        this.column.getTable().setDatabase("DEFAULT");
    }

    public boolean isInnerColumn() {
        return InnerDataTypeEnum.contains(this.getDatatype());
    }

    public boolean isDerivedDataType() {
        return InnerDataTypeEnum.DERIVED.getDataType().equals(this.getDatatype());
    }

    public boolean isSameAs(String tableName, String columnName) {
        return this.column.isSameAs(tableName, columnName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column.getTable().getIdentity().hashCode();
        result = 31 * result + this.column.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TblColRef other = (TblColRef)obj;
        if (!StringUtils.equals((String)this.column.getTable().getIdentity(), (String)other.column.getTable().getIdentity())) {
            return false;
        }
        return StringUtils.equals((String)this.column.getName(), (String)other.column.getName());
    }

    public String toString() {
        return (this.column.getTable() == null ? null : this.column.getTable().getIdentity()) + "." + this.column.getName();
    }

    public static enum InnerDataTypeEnum {
        LITERAL("_literal_type"),
        DERIVED("_derived_type");

        private final String dateType;

        private InnerDataTypeEnum(String name) {
            this.dateType = name;
        }

        public String getDataType() {
            return this.dateType;
        }

        public static boolean contains(String name) {
            return LITERAL.getDataType().equals(name) || DERIVED.getDataType().equals(name);
        }
    }
}

