/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class PartitionDesc {
    @JsonProperty(value="partition_date_column")
    private String partitionDateColumn;
    @JsonProperty(value="partition_time_column")
    private String partitionTimeColumn;
    @JsonProperty(value="partition_date_start")
    private long partitionDateStart = 0L;
    @JsonProperty(value="partition_date_format")
    private String partitionDateFormat = "yyyy-MM-dd";
    @JsonProperty(value="partition_time_format")
    private String partitionTimeFormat = "HH:mm:ss";
    @JsonProperty(value="partition_type")
    private PartitionType partitionType = PartitionType.APPEND;
    @JsonProperty(value="partition_condition_builder")
    private String partitionConditionBuilderClz = DefaultPartitionConditionBuilder.class.getName();
    private TblColRef partitionDateColumnRef;
    private IPartitionConditionBuilder partitionConditionBuilder;

    public void init(Map<String, TableDesc> tables) {
        ColumnDesc col;
        if (StringUtils.isEmpty(this.partitionDateColumn)) {
            return;
        }
        this.partitionDateColumn = this.partitionDateColumn.toUpperCase();
        String[] columns = StringSplitter.split(this.partitionDateColumn, ".");
        if (null != columns && columns.length == 3) {
            String tableName = columns[0].toUpperCase() + "." + columns[1].toUpperCase();
            TableDesc table = tables.get(tableName);
            col = table.findColumnByName(columns[2]);
            if (col == null) {
                throw new IllegalStateException("The column '" + this.partitionDateColumn + "' provided in 'partition_date_column' doesn't exist.");
            }
        } else {
            throw new IllegalStateException("The 'partition_date_column' format is invalid: " + this.partitionDateColumn + ", it should be {db}.{table}.{column}.");
        }
        this.partitionDateColumnRef = new TblColRef(col);
        this.partitionConditionBuilder = (IPartitionConditionBuilder)ClassUtil.newInstance(this.partitionConditionBuilderClz);
    }

    public boolean partitionColumnIsYmdInt() {
        if (this.partitionDateColumnRef == null) {
            return false;
        }
        DataType type = this.partitionDateColumnRef.getType();
        return type.isInt();
    }

    public boolean partitionColumnIsTimeMillis() {
        if (this.partitionDateColumnRef == null) {
            return false;
        }
        DataType type = this.partitionDateColumnRef.getType();
        return type.isBigInt();
    }

    public boolean isPartitioned() {
        return this.partitionDateColumnRef != null;
    }

    public String getPartitionDateColumn() {
        return this.partitionDateColumn;
    }

    public void setPartitionDateColumn(String partitionDateColumn) {
        this.partitionDateColumn = partitionDateColumn;
    }

    public String getPartitionTimeColumn() {
        return this.partitionTimeColumn;
    }

    public void setPartitionTimeColumn(String partitionTimeColumn) {
        this.partitionTimeColumn = partitionTimeColumn;
    }

    @Deprecated
    public long getPartitionDateStart() {
        return this.partitionDateStart;
    }

    @Deprecated
    public void setPartitionDateStart(long partitionDateStart) {
        this.partitionDateStart = partitionDateStart;
    }

    public String getPartitionDateFormat() {
        return this.partitionDateFormat;
    }

    public void setPartitionDateFormat(String partitionDateFormat) {
        this.partitionDateFormat = partitionDateFormat;
    }

    public String getPartitionTimeFormat() {
        return this.partitionTimeFormat;
    }

    public void setPartitionTimeFormat(String partitionTimeFormat) {
        this.partitionTimeFormat = partitionTimeFormat;
    }

    public PartitionType getCubePartitionType() {
        return this.partitionType;
    }

    public void setCubePartitionType(PartitionType partitionType) {
        this.partitionType = partitionType;
    }

    public IPartitionConditionBuilder getPartitionConditionBuilder() {
        return this.partitionConditionBuilder;
    }

    public TblColRef getPartitionDateColumnRef() {
        return this.partitionDateColumnRef;
    }

    public static PartitionDesc getCopyOf(PartitionDesc partitionDesc) {
        PartitionDesc newPartDesc = new PartitionDesc();
        newPartDesc.setCubePartitionType(partitionDesc.getCubePartitionType());
        newPartDesc.setPartitionDateColumn(partitionDesc.getPartitionDateColumn());
        newPartDesc.setPartitionDateFormat(partitionDesc.getPartitionDateFormat());
        newPartDesc.setPartitionDateStart(partitionDesc.getPartitionDateStart());
        return newPartDesc;
    }

    public static class YearMonthDayPartitionConditionBuilder
    implements IPartitionConditionBuilder {
        @Override
        public String buildDateRangeCondition(PartitionDesc partDesc, long startInclusive, long endExclusive, Map<String, String> tableAlias) {
            String partitionColumnName = partDesc.getPartitionDateColumn();
            int indexOfDot = partitionColumnName.lastIndexOf(".");
            if (indexOfDot <= 0) {
                throw new IllegalStateException("The partitionColumnName is invalid: " + partitionColumnName);
            }
            String partitionTableName = partitionColumnName.substring(0, indexOfDot).toUpperCase();
            if (tableAlias.containsKey(partitionTableName)) {
                partitionTableName = tableAlias.get(partitionTableName);
            }
            String concatField = String.format("CONCAT(%s.YEAR,'-',%s.MONTH,'-',%s.DAY)", partitionTableName, partitionTableName, partitionTableName);
            StringBuilder builder = new StringBuilder();
            if (startInclusive > 0L) {
                builder.append(concatField + " >= '" + DateFormat.formatToDateStr(startInclusive) + "' ");
                builder.append("AND ");
            }
            builder.append(concatField + " < '" + DateFormat.formatToDateStr(endExclusive) + "'");
            return builder.toString();
        }
    }

    public static class DefaultPartitionConditionBuilder
    implements IPartitionConditionBuilder {
        @Override
        public String buildDateRangeCondition(PartitionDesc partDesc, long startInclusive, long endExclusive, Map<String, String> tableAlias) {
            StringBuilder builder = new StringBuilder();
            String partitionDateColumnName = partDesc.getPartitionDateColumn();
            String partitionTimeColumnName = partDesc.getPartitionTimeColumn();
            if (partDesc.partitionColumnIsYmdInt()) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsYmdInt(builder, partitionDateColumnName, startInclusive, endExclusive, tableAlias);
            } else if (partDesc.partitionColumnIsTimeMillis()) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondAsTimeMillis(builder, partitionDateColumnName, startInclusive, endExclusive, tableAlias);
            } else if (partitionDateColumnName != null && partitionTimeColumnName == null) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondition(builder, partitionDateColumnName, startInclusive, endExclusive, partDesc.getPartitionDateFormat(), tableAlias);
            } else if (partitionDateColumnName == null && partitionTimeColumnName != null) {
                DefaultPartitionConditionBuilder.buildSingleColumnRangeCondition(builder, partitionTimeColumnName, startInclusive, endExclusive, partDesc.getPartitionTimeFormat(), tableAlias);
            } else if (partitionDateColumnName != null && partitionTimeColumnName != null) {
                DefaultPartitionConditionBuilder.buildMultipleColumnRangeCondition(builder, partitionDateColumnName, partitionTimeColumnName, startInclusive, endExclusive, partDesc.getPartitionDateFormat(), partDesc.getPartitionTimeFormat(), tableAlias);
            }
            return builder.toString();
        }

        private static String replaceColumnNameWithAlias(String columnName, Map<String, String> tableAlias) {
            int indexOfDot = columnName.lastIndexOf(".");
            if (indexOfDot > 0) {
                String partitionTableName = columnName.substring(0, indexOfDot);
                if (tableAlias != null && tableAlias.containsKey(partitionTableName)) {
                    columnName = tableAlias.get(partitionTableName) + columnName.substring(indexOfDot);
                }
            }
            return columnName;
        }

        private static void buildSingleColumnRangeCondAsTimeMillis(StringBuilder builder, String partitionColumnName, long startInclusive, long endExclusive, Map<String, String> tableAlias) {
            partitionColumnName = DefaultPartitionConditionBuilder.replaceColumnNameWithAlias(partitionColumnName, tableAlias);
            if (startInclusive > 0L) {
                builder.append(partitionColumnName + " >= " + startInclusive);
                builder.append(" AND ");
            }
            builder.append(partitionColumnName + " < " + endExclusive);
        }

        private static void buildSingleColumnRangeCondAsYmdInt(StringBuilder builder, String partitionColumnName, long startInclusive, long endExclusive, Map<String, String> tableAlias) {
            partitionColumnName = DefaultPartitionConditionBuilder.replaceColumnNameWithAlias(partitionColumnName, tableAlias);
            if (startInclusive > 0L) {
                builder.append(partitionColumnName + " >= " + DateFormat.formatToDateStr(startInclusive, "yyyyMMdd"));
                builder.append(" AND ");
            }
            builder.append(partitionColumnName + " < " + DateFormat.formatToDateStr(endExclusive, "yyyyMMdd"));
        }

        private static void buildSingleColumnRangeCondition(StringBuilder builder, String partitionColumnName, long startInclusive, long endExclusive, String partitionColumnDateFormat, Map<String, String> tableAlias) {
            partitionColumnName = DefaultPartitionConditionBuilder.replaceColumnNameWithAlias(partitionColumnName, tableAlias);
            if (startInclusive > 0L) {
                builder.append(partitionColumnName + " >= '" + DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat) + "'");
                builder.append(" AND ");
            }
            builder.append(partitionColumnName + " < '" + DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat) + "'");
        }

        private static void buildMultipleColumnRangeCondition(StringBuilder builder, String partitionDateColumnName, String partitionTimeColumnName, long startInclusive, long endExclusive, String partitionColumnDateFormat, String partitionColumnTimeFormat, Map<String, String> tableAlias) {
            partitionDateColumnName = DefaultPartitionConditionBuilder.replaceColumnNameWithAlias(partitionDateColumnName, tableAlias);
            partitionTimeColumnName = DefaultPartitionConditionBuilder.replaceColumnNameWithAlias(partitionTimeColumnName, tableAlias);
            if (startInclusive > 0L) {
                builder.append("(");
                builder.append("(");
                builder.append(partitionDateColumnName + " = '" + DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat) + "'").append(" AND ").append(partitionTimeColumnName + " >= '" + DateFormat.formatToDateStr(startInclusive, partitionColumnTimeFormat) + "'");
                builder.append(")");
                builder.append(" OR ");
                builder.append("(");
                builder.append(partitionDateColumnName + " > '" + DateFormat.formatToDateStr(startInclusive, partitionColumnDateFormat) + "'");
                builder.append(")");
                builder.append(")");
                builder.append(" AND ");
            }
            builder.append("(");
            builder.append("(");
            builder.append(partitionDateColumnName + " = '" + DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat) + "'").append(" AND ").append(partitionTimeColumnName + " < '" + DateFormat.formatToDateStr(endExclusive, partitionColumnTimeFormat) + "'");
            builder.append(")");
            builder.append(" OR ");
            builder.append("(");
            builder.append(partitionDateColumnName + " < '" + DateFormat.formatToDateStr(endExclusive, partitionColumnDateFormat) + "'");
            builder.append(")");
            builder.append(")");
        }
    }

    public static interface IPartitionConditionBuilder {
        public String buildDateRangeCondition(PartitionDesc var1, long var2, long var4, Map<String, String> var6);
    }

    public static enum PartitionType {
        APPEND,
        UPDATE_INSERT;

    }
}

