/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class JoinDesc {
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="primary_key")
    private String[] primaryKey;
    @JsonProperty(value="foreign_key")
    private String[] foreignKey;
    private TblColRef[] primaryKeyColumns;
    private TblColRef[] foreignKeyColumns;

    public void swapPKFK() {
        String[] t = this.primaryKey;
        this.primaryKey = this.foreignKey;
        this.foreignKey = t;
        TblColRef[] tt = this.primaryKeyColumns;
        this.primaryKeyColumns = this.foreignKeyColumns;
        this.foreignKeyColumns = tt;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String[] getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String[] primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String[] getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(String[] foreignKey) {
        this.foreignKey = foreignKey;
    }

    public TblColRef[] getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public void setPrimaryKeyColumns(TblColRef[] primaryKeyColumns) {
        this.primaryKeyColumns = primaryKeyColumns;
    }

    public TblColRef[] getForeignKeyColumns() {
        return this.foreignKeyColumns;
    }

    public void setForeignKeyColumns(TblColRef[] foreignKeyColumns) {
        this.foreignKeyColumns = foreignKeyColumns;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.primaryKeyColumns);
        result = 31 * result + Arrays.hashCode(this.foreignKeyColumns);
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoinDesc other = (JoinDesc)obj;
        if (!this.columnsEqualIgnoringOrder(this.foreignKeyColumns, other.foreignKeyColumns)) {
            return false;
        }
        if (!this.columnsEqualIgnoringOrder(this.primaryKeyColumns, other.primaryKeyColumns)) {
            return false;
        }
        return this.type.equalsIgnoreCase(other.getType());
    }

    private boolean columnsEqualIgnoringOrder(TblColRef[] a, TblColRef[] b) {
        if (a.length != b.length) {
            return false;
        }
        return Arrays.asList(a).containsAll(Arrays.asList(b));
    }

    public String toString() {
        return "JoinDesc [type=" + this.type + ", primary_key=" + Arrays.toString(this.primaryKey) + ", foreign_key=" + Arrays.toString(this.foreignKey) + "]";
    }
}

