/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class LogicalTupleFilter
extends TupleFilter {
    public LogicalTupleFilter(TupleFilter.FilterOperatorEnum op) {
        super(new ArrayList<TupleFilter>(2), op);
        boolean opGood;
        boolean bl = opGood = op == TupleFilter.FilterOperatorEnum.AND || op == TupleFilter.FilterOperatorEnum.OR || op == TupleFilter.FilterOperatorEnum.NOT;
        if (!opGood) {
            throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)op));
        }
    }

    private LogicalTupleFilter(List<TupleFilter> filters, TupleFilter.FilterOperatorEnum op) {
        super(filters, op);
    }

    @Override
    public TupleFilter copy() {
        LinkedList<TupleFilter> cloneChildren = new LinkedList<TupleFilter>(this.children);
        LogicalTupleFilter cloneTuple = new LogicalTupleFilter(cloneChildren, this.operator);
        return cloneTuple;
    }

    @Override
    public TupleFilter reverse() {
        switch (this.operator) {
            case NOT: {
                throw new IllegalStateException("not( not in ()) is invalid syntax");
            }
            case AND: 
            case OR: {
                LogicalTupleFilter reverse = new LogicalTupleFilter((TupleFilter.FilterOperatorEnum)((Object)REVERSE_OP_MAP.get((Object)this.operator)));
                for (TupleFilter child : this.children) {
                    reverse.addChild(child.reverse());
                }
                return reverse;
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return (Object)((Object)this.operator) + " " + this.children;
    }

    @Override
    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        switch (this.operator) {
            case AND: {
                return this.evalAnd(tuple, cs);
            }
            case OR: {
                return this.evalOr(tuple, cs);
            }
            case NOT: {
                return this.evalNot(tuple, cs);
            }
        }
        return false;
    }

    private boolean evalAnd(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        for (TupleFilter filter : this.children) {
            if (filter.evaluate(tuple, cs)) continue;
            return false;
        }
        return true;
    }

    private boolean evalOr(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        for (TupleFilter filter : this.children) {
            if (!filter.evaluate(tuple, cs)) continue;
            return true;
        }
        return false;
    }

    private boolean evalNot(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        return !((TupleFilter)this.children.get(0)).evaluate(tuple, cs);
    }

    @Override
    public Collection<?> getValues() {
        return Collections.emptyList();
    }

    @Override
    public boolean isEvaluable() {
        switch (this.operator) {
            case NOT: {
                for (TupleFilter child : this.children) {
                    if (TupleFilter.isEvaluableRecursively(child)) continue;
                    return false;
                }
                return true;
            }
            case OR: {
                for (TupleFilter child : this.children) {
                    if (TupleFilter.isEvaluableRecursively(child)) continue;
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }
}

