/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class ColumnTupleFilter
extends TupleFilter {
    private TblColRef columnRef;
    private Object tupleValue;
    private List<Object> values;

    public ColumnTupleFilter(TblColRef column) {
        super(Collections.emptyList(), TupleFilter.FilterOperatorEnum.COLUMN);
        this.columnRef = column;
        this.values = new ArrayList<Object>(1);
        this.values.add(null);
    }

    public TblColRef getColumn() {
        return this.columnRef;
    }

    public void setColumn(TblColRef col) {
        this.columnRef = col;
    }

    @Override
    public void addChild(TupleFilter child) {
        throw new UnsupportedOperationException("This is " + this + " and child is " + child);
    }

    public String toString() {
        return "" + this.columnRef;
    }

    @Override
    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        this.tupleValue = tuple.getValue(this.columnRef);
        return true;
    }

    @Override
    public boolean isEvaluable() {
        return true;
    }

    @Override
    public Collection<?> getValues() {
        this.values.set(0, this.tupleValue);
        return this.values;
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        String table = this.columnRef.getTable();
        BytesUtil.writeUTFString(table, buffer);
        String columnId = this.columnRef.getColumnDesc().getId();
        BytesUtil.writeUTFString(columnId, buffer);
        String columnName = this.columnRef.getName();
        BytesUtil.writeUTFString(columnName, buffer);
        String dataType = this.columnRef.getDatatype();
        BytesUtil.writeUTFString(dataType, buffer);
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
        TableDesc table = null;
        ColumnDesc column = new ColumnDesc();
        String tableName = BytesUtil.readUTFString(buffer);
        if (tableName != null) {
            table = new TableDesc();
            table.setName(tableName);
        }
        column.setId(BytesUtil.readUTFString(buffer));
        column.setName(BytesUtil.readUTFString(buffer));
        column.setDatatype(BytesUtil.readUTFString(buffer));
        column.init(table);
        this.columnRef = column.getRef();
    }
}

