/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class CaseTupleFilter
extends TupleFilter {
    private List<TupleFilter> whenFilters;
    private List<TupleFilter> thenFilters;
    private TupleFilter elseFilter = null;
    private Collection<?> values = Collections.emptyList();
    private int filterIndex = 0;

    public CaseTupleFilter() {
        super(new ArrayList<TupleFilter>(), TupleFilter.FilterOperatorEnum.CASE);
        this.whenFilters = new ArrayList<TupleFilter>();
        this.thenFilters = new ArrayList<TupleFilter>();
    }

    @Override
    public void addChild(TupleFilter child) {
        super.addChild(child);
        if (this.filterIndex % 2 == 0) {
            this.whenFilters.add(child);
        } else {
            this.thenFilters.add(child);
        }
        ++this.filterIndex;
    }

    public String toString() {
        return "CaseTupleFilter [when=" + this.whenFilters + ", then=" + this.thenFilters + ", else=" + this.elseFilter + ", children=" + this.children + "]";
    }

    @Override
    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        if (this.whenFilters.size() != this.thenFilters.size()) {
            this.elseFilter = this.whenFilters.remove(this.whenFilters.size() - 1);
        }
        boolean matched = false;
        for (int i = 0; i < this.whenFilters.size(); ++i) {
            TupleFilter whenFilter = this.whenFilters.get(i);
            if (!whenFilter.evaluate(tuple, cs)) continue;
            TupleFilter thenFilter = this.thenFilters.get(i);
            thenFilter.evaluate(tuple, cs);
            this.values = thenFilter.getValues();
            matched = true;
            break;
        }
        if (!matched) {
            if (this.elseFilter != null) {
                this.elseFilter.evaluate(tuple, cs);
                this.values = this.elseFilter.getValues();
            } else {
                this.values = Collections.emptyList();
            }
        }
        return true;
    }

    @Override
    public boolean isEvaluable() {
        return false;
    }

    @Override
    public Collection<?> getValues() {
        return this.values;
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }
}

