/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.datatype.IntMutable;

public class Int4Serializer
extends DataTypeSerializer<IntMutable> {
    private ThreadLocal<IntMutable> current = new ThreadLocal();

    public Int4Serializer(DataType type) {
    }

    @Override
    public void serialize(IntMutable value, ByteBuffer out) {
        BytesUtil.writeUnsigned(value.get(), 4, out);
    }

    private IntMutable current() {
        IntMutable l = this.current.get();
        if (l == null) {
            l = new IntMutable();
            this.current.set(l);
        }
        return l;
    }

    @Override
    public IntMutable deserialize(ByteBuffer in) {
        IntMutable l = this.current();
        l.set(BytesUtil.readUnsigned(in, 4));
        return l;
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return 4;
    }

    @Override
    public int maxLength() {
        return 4;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 4;
    }

    @Override
    public IntMutable valueOf(String str) {
        return new IntMutable(Integer.parseInt(str));
    }
}

