/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.nio.ByteBuffer;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.datatype.DoubleMutable;

public class DoubleSerializer
extends DataTypeSerializer<DoubleMutable> {
    private ThreadLocal<DoubleMutable> current = new ThreadLocal();

    public DoubleSerializer(DataType type) {
    }

    @Override
    public void serialize(DoubleMutable value, ByteBuffer out) {
        out.putDouble(value.get());
    }

    private DoubleMutable current() {
        DoubleMutable d = this.current.get();
        if (d == null) {
            d = new DoubleMutable();
            this.current.set(d);
        }
        return d;
    }

    @Override
    public DoubleMutable deserialize(ByteBuffer in) {
        DoubleMutable d = this.current();
        d.set(in.getDouble());
        return d;
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return 8;
    }

    @Override
    public int maxLength() {
        return 8;
    }

    @Override
    public int getStorageBytesEstimate() {
        return 8;
    }

    @Override
    public DoubleMutable valueOf(String str) {
        return new DoubleMutable(Double.parseDouble(str));
    }
}

