/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.topn;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.topn.Counter;
import org.apache.kylin.measure.topn.TopNAggregator;
import org.apache.kylin.measure.topn.TopNCounter;
import org.apache.kylin.measure.topn.TopNCounterSerializer;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNMeasureType
extends MeasureType<TopNCounter<ByteArray>> {
    private static final Logger logger = LoggerFactory.getLogger(TopNMeasureType.class);
    public static final String FUNC_TOP_N = "TOP_N";
    public static final String DATATYPE_TOPN = "topn";
    public static final String CONFIG_ENCODING_PREFIX = "topn.encoding.";
    public static final String CONFIG_AGG = "topn.aggregation";
    public static final String CONFIG_ORDER = "topn.order";
    private final DataType dataType;

    public TopNMeasureType(String funcName, DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void validate(FunctionDesc functionDesc) throws IllegalArgumentException {
        this.validate(functionDesc.getExpression(), functionDesc.getReturnDataType(), true);
    }

    private void validate(String funcName, DataType dataType, boolean checkDataType) {
        if (!FUNC_TOP_N.equals(funcName)) {
            throw new IllegalArgumentException();
        }
        if (!DATATYPE_TOPN.equals(dataType.getName())) {
            throw new IllegalArgumentException();
        }
        if (dataType.getPrecision() < 1 || dataType.getPrecision() > 10000) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isMemoryHungry() {
        return true;
    }

    @Override
    public MeasureIngester<TopNCounter<ByteArray>> newIngester() {
        return new MeasureIngester<TopNCounter<ByteArray>>(){
            private DimensionEncoding[] dimensionEncodings = null;
            private List<TblColRef> literalCols = null;
            private int keyLength = 0;
            private DimensionEncoding[] newDimensionEncodings = null;
            private int newKeyLength = 0;
            private boolean needReEncode = true;

            @Override
            public TopNCounter<ByteArray> valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                double counter;
                double d = counter = values[0] == null ? 0.0 : Double.parseDouble(values[0]);
                if (this.dimensionEncodings == null) {
                    this.literalCols = TopNMeasureType.this.getTopNLiteralColumn(measureDesc.getFunction());
                    for (DimensionEncoding encoding : this.dimensionEncodings = TopNMeasureType.getDimensionEncodings(measureDesc.getFunction(), this.literalCols, dictionaryMap)) {
                        this.keyLength += encoding.getLengthOfEncoding();
                    }
                    if (values.length != this.literalCols.size() + 1) {
                        throw new IllegalArgumentException();
                    }
                }
                ByteArray key = new ByteArray(this.keyLength);
                int offset = 0;
                for (int i = 0; i < this.dimensionEncodings.length; ++i) {
                    byte[] valueBytes = Bytes.toBytes(values[i + 1]);
                    this.dimensionEncodings[i].encode(valueBytes, valueBytes.length, key.array(), offset);
                    offset += this.dimensionEncodings[i].getLengthOfEncoding();
                }
                TopNCounter<ByteArray> topNCounter = new TopNCounter<ByteArray>(TopNMeasureType.this.dataType.getPrecision() * 50);
                topNCounter.offer(key, counter);
                return topNCounter;
            }

            @Override
            public TopNCounter<ByteArray> reEncodeDictionary(TopNCounter<ByteArray> value, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> oldDicts, Map<TblColRef, Dictionary<String>> newDicts) {
                TopNCounter<ByteArray> topNCounter = value;
                if (this.newDimensionEncodings == null) {
                    this.literalCols = TopNMeasureType.this.getTopNLiteralColumn(measureDesc.getFunction());
                    this.dimensionEncodings = TopNMeasureType.getDimensionEncodings(measureDesc.getFunction(), this.literalCols, oldDicts);
                    this.keyLength = 0;
                    boolean hasDictEncoding = false;
                    for (DimensionEncoding dimensionEncoding : this.dimensionEncodings) {
                        this.keyLength += dimensionEncoding.getLengthOfEncoding();
                        if (!(dimensionEncoding instanceof DictionaryDimEnc)) continue;
                        hasDictEncoding = true;
                    }
                    this.newDimensionEncodings = TopNMeasureType.getDimensionEncodings(measureDesc.getFunction(), this.literalCols, newDicts);
                    this.newKeyLength = 0;
                    for (DimensionEncoding dimensionEncoding : this.newDimensionEncodings) {
                        this.newKeyLength += dimensionEncoding.getLengthOfEncoding();
                    }
                    this.needReEncode = hasDictEncoding;
                }
                if (!this.needReEncode) {
                    return topNCounter;
                }
                int topNSize = topNCounter.size();
                byte[] newIdBuf = new byte[topNSize * this.newKeyLength];
                int bufOffset = 0;
                for (Counter<ByteArray> counter : topNCounter) {
                    int offset = counter.getItem().offset();
                    int innerBuffOffset = 0;
                    for (int i = 0; i < this.dimensionEncodings.length; ++i) {
                        String dimValue = this.dimensionEncodings[i].decode(counter.getItem().array(), offset, this.dimensionEncodings[i].getLengthOfEncoding());
                        byte[] dimValueBytes = Bytes.toBytes(dimValue);
                        this.newDimensionEncodings[i].encode(dimValueBytes, dimValueBytes.length, newIdBuf, bufOffset + innerBuffOffset);
                        innerBuffOffset += this.newDimensionEncodings[i].getLengthOfEncoding();
                        offset += this.dimensionEncodings[i].getLengthOfEncoding();
                    }
                    counter.getItem().set(newIdBuf, bufOffset, this.newKeyLength);
                    bufOffset += this.newKeyLength;
                }
                return topNCounter;
            }
        };
    }

    @Override
    public MeasureAggregator<TopNCounter<ByteArray>> newAggregator() {
        return new TopNAggregator();
    }

    @Override
    public List<TblColRef> getColumnsNeedDictionary(FunctionDesc functionDesc) {
        int start;
        ArrayList columnsNeedDict = Lists.newArrayList();
        List<TblColRef> allCols = functionDesc.getParameter().getColRefs();
        for (int i = start = functionDesc.getParameter().isColumnType() ? 1 : 0; i < allCols.size(); ++i) {
            TblColRef tblColRef = allCols.get(i);
            String encoding = functionDesc.getConfiguration().get(CONFIG_ENCODING_PREFIX + tblColRef.getName());
            if (!StringUtils.isEmpty(encoding) && !"dict".equals(encoding)) continue;
            columnsNeedDict.add(tblColRef);
        }
        return columnsNeedDict;
    }

    @Override
    public CapabilityResult.CapabilityInfluence influenceCapabilityCheck(Collection<TblColRef> unmatchedDimensions, Collection<FunctionDesc> unmatchedAggregations, SQLDigest digest, MeasureDesc topN) {
        if (digest.aggregations.size() != 1) {
            return null;
        }
        FunctionDesc onlyFunction = digest.aggregations.iterator().next();
        if (!this.isTopNCompatibleSum(topN.getFunction(), onlyFunction)) {
            return null;
        }
        List<TblColRef> literalCol = this.getTopNLiteralColumn(topN.getFunction());
        if (!unmatchedDimensions.containsAll(literalCol)) {
            return null;
        }
        if (!digest.groupbyColumns.containsAll(literalCol)) {
            return null;
        }
        unmatchedDimensions.removeAll(literalCol);
        unmatchedAggregations.remove(onlyFunction);
        return new CapabilityResult.CapabilityInfluence(){

            @Override
            public double suggestCostMultiplier() {
                return 0.3;
            }
        };
    }

    private boolean isTopNCompatibleSum(FunctionDesc topN, FunctionDesc sum) {
        if (sum == null) {
            return false;
        }
        if (!this.isTopN(topN)) {
            return false;
        }
        TblColRef topnNumCol = this.getTopNNumericColumn(topN);
        if (topnNumCol == null) {
            return sum.isCount();
        }
        if (!sum.isSum()) {
            return false;
        }
        if (sum.getParameter() == null || sum.getParameter().getColRefs() == null || sum.getParameter().getColRefs().size() == 0) {
            return false;
        }
        TblColRef sumCol = sum.getParameter().getColRefs().get(0);
        return sumCol.equals(topnNumCol);
    }

    @Override
    public boolean needRewrite() {
        return false;
    }

    @Override
    public Class<?> getRewriteCalciteAggrFunctionClass() {
        return null;
    }

    @Override
    public void adjustSqlDigest(List<MeasureDesc> measureDescs, SQLDigest sqlDigest) {
        for (MeasureDesc measureDesc : measureDescs) {
            FunctionDesc topnFunc = measureDesc.getFunction();
            List<TblColRef> topnLiteralCol = this.getTopNLiteralColumn(topnFunc);
            if (!sqlDigest.groupbyColumns.containsAll(topnLiteralCol)) {
                return;
            }
            if (sqlDigest.aggregations.size() > 1) {
                throw new IllegalStateException("When query with topN, only one metrics is allowed.");
            }
            if (sqlDigest.aggregations.size() > 0) {
                FunctionDesc origFunc = sqlDigest.aggregations.iterator().next();
                if (!origFunc.isSum() && !origFunc.isCount()) {
                    throw new IllegalStateException("When query with topN, only SUM function is allowed.");
                }
                logger.info("Rewrite function " + origFunc + " to " + topnFunc);
            }
            sqlDigest.aggregations = Lists.newArrayList((Object[])new FunctionDesc[]{topnFunc});
            sqlDigest.groupbyColumns.removeAll(topnLiteralCol);
            sqlDigest.metricColumns.addAll(topnLiteralCol);
        }
    }

    @Override
    public boolean needAdvancedTupleFilling() {
        return true;
    }

    @Override
    public void fillTupleSimply(Tuple tuple, int indexInTuple, Object measureValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MeasureType.IAdvMeasureFiller getAdvancedTupleFiller(FunctionDesc function, TupleInfo tupleInfo, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        List<TblColRef> literalCols = this.getTopNLiteralColumn(function);
        TblColRef numericCol = this.getTopNNumericColumn(function);
        final int[] literalTupleIdx = new int[literalCols.size()];
        final DimensionEncoding[] dimensionEncodings = TopNMeasureType.getDimensionEncodings(function, literalCols, dictionaryMap);
        for (int i = 0; i < literalCols.size(); ++i) {
            TblColRef colRef = literalCols.get(i);
            literalTupleIdx[i] = tupleInfo.hasColumn(colRef) ? tupleInfo.getColumnIndex(colRef) : -1;
        }
        final int numericTupleIdx = numericCol != null ? (tupleInfo.hasColumn(numericCol) ? tupleInfo.getColumnIndex(numericCol) : -1) : tupleInfo.getFieldIndex("COUNT__");
        return new MeasureType.IAdvMeasureFiller(){
            private TopNCounter<ByteArray> topNCounter;
            private Iterator<Counter<ByteArray>> topNCounterIterator;
            private int expectRow = 0;

            @Override
            public void reload(Object measureValue) {
                this.topNCounter = (TopNCounter)measureValue;
                this.topNCounterIterator = this.topNCounter.iterator();
                this.expectRow = 0;
            }

            @Override
            public int getNumOfRows() {
                return this.topNCounter.size();
            }

            @Override
            public void fillTuple(Tuple tuple, int row) {
                if (this.expectRow++ != row) {
                    throw new IllegalStateException();
                }
                Counter<ByteArray> counter = this.topNCounterIterator.next();
                int offset = counter.getItem().offset();
                for (int i = 0; i < dimensionEncodings.length; ++i) {
                    String colValue = dimensionEncodings[i].decode(counter.getItem().array(), offset, dimensionEncodings[i].getLengthOfEncoding());
                    tuple.setDimensionValue(literalTupleIdx[i], colValue);
                    offset += dimensionEncodings[i].getLengthOfEncoding();
                }
                tuple.setMeasureValue(numericTupleIdx, (Object)counter.getCount());
            }
        };
    }

    private static DimensionEncoding[] getDimensionEncodings(FunctionDesc function, List<TblColRef> literalCols, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        DimensionEncoding[] dimensionEncodings = new DimensionEncoding[literalCols.size()];
        for (int i = 0; i < literalCols.size(); ++i) {
            TblColRef colRef = literalCols.get(i);
            String encoding = function.getConfiguration().get(CONFIG_ENCODING_PREFIX + colRef.getName());
            if (StringUtils.isEmpty(encoding) || "dict".equals(encoding)) {
                dimensionEncodings[i] = new DictionaryDimEnc(dictionaryMap.get(colRef));
                continue;
            }
            Object[] encodingConf = DimensionEncoding.parseEncodingConf(encoding);
            dimensionEncodings[i] = DimensionEncodingFactory.create((String)encodingConf[0], (String[])encodingConf[1]);
        }
        return dimensionEncodings;
    }

    private TblColRef getTopNNumericColumn(FunctionDesc functionDesc) {
        if (functionDesc.getParameter().isColumnType()) {
            return functionDesc.getParameter().getColRefs().get(0);
        }
        return null;
    }

    private List<TblColRef> getTopNLiteralColumn(FunctionDesc functionDesc) {
        List<TblColRef> allColumns = functionDesc.getParameter().getColRefs();
        if (!functionDesc.getParameter().isColumnType()) {
            return allColumns;
        }
        return allColumns.subList(1, allColumns.size());
    }

    private boolean isTopN(FunctionDesc functionDesc) {
        return FUNC_TOP_N.equalsIgnoreCase(functionDesc.getExpression());
    }

    public static class Factory
    extends MeasureTypeFactory<TopNCounter<ByteArray>> {
        @Override
        public MeasureType<TopNCounter<ByteArray>> createMeasureType(String funcName, DataType dataType) {
            return new TopNMeasureType(funcName, dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return TopNMeasureType.FUNC_TOP_N;
        }

        @Override
        public String getAggrDataTypeName() {
            return TopNMeasureType.DATATYPE_TOPN;
        }

        @Override
        public Class<? extends DataTypeSerializer<TopNCounter<ByteArray>>> getAggrDataTypeSerializer() {
            return TopNCounterSerializer.class;
        }
    }
}

