/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.topn;

import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.topn.TopNCounter;

public class TopNAggregator
extends MeasureAggregator<TopNCounter<ByteArray>> {
    int capacity = 0;
    TopNCounter<ByteArray> sum = null;

    @Override
    public void reset() {
        this.sum = null;
    }

    @Override
    public void aggregate(TopNCounter<ByteArray> value) {
        if (this.sum == null) {
            this.capacity = value.getCapacity();
            this.sum = new TopNCounter(this.capacity * 10);
        }
        this.sum.merge(value);
    }

    @Override
    public TopNCounter<ByteArray> getState() {
        this.sum.retain(this.capacity);
        return this.sum;
    }

    @Override
    public int getMemBytesEstimate() {
        return 8 * this.capacity / 4;
    }
}

