/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.bitmap.BitmapAggregator;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.bitmap.BitmapDistinctCountAggFunc;
import org.apache.kylin.measure.bitmap.BitmapSerializer;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class BitmapMeasureType
extends MeasureType<BitmapCounter> {
    public static final String FUNC_COUNT_DISTINCT = "COUNT_DISTINCT";
    public static final String DATATYPE_BITMAP = "bitmap";
    public DataType dataType;

    public BitmapMeasureType(String funcName, DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void validate(FunctionDesc functionDesc) throws IllegalArgumentException {
        if (!FUNC_COUNT_DISTINCT.equals(functionDesc.getExpression())) {
            throw new IllegalArgumentException("BitmapMeasureType func is not COUNT_DISTINCT but " + functionDesc.getExpression());
        }
        if (!DATATYPE_BITMAP.equals(functionDesc.getReturnDataType().getName())) {
            throw new IllegalArgumentException("BitmapMeasureType datatype is not bitmap but " + functionDesc.getReturnDataType().getName());
        }
    }

    @Override
    public boolean isMemoryHungry() {
        return true;
    }

    @Override
    public MeasureIngester<BitmapCounter> newIngester() {
        return new MeasureIngester<BitmapCounter>(){
            BitmapCounter current = new BitmapCounter();

            @Override
            public BitmapCounter valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                BitmapCounter bitmap = this.current;
                bitmap.clear();
                if (BitmapMeasureType.this.needDictionaryColumn(measureDesc.getFunction())) {
                    TblColRef literalCol = measureDesc.getFunction().getParameter().getColRefs().get(0);
                    Dictionary<String> dictionary = dictionaryMap.get(literalCol);
                    if (values != null && values.length > 0 && values[0] != null) {
                        int id = dictionary.getIdFromValue(values[0]);
                        bitmap.add(id);
                    }
                } else {
                    for (String value : values) {
                        bitmap.add(value);
                    }
                }
                return bitmap;
            }

            @Override
            public BitmapCounter reEncodeDictionary(BitmapCounter value, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> oldDicts, Map<TblColRef, Dictionary<String>> newDicts) {
                if (!BitmapMeasureType.this.needDictionaryColumn(measureDesc.getFunction())) {
                    return value;
                }
                TblColRef colRef = measureDesc.getFunction().getParameter().getColRefs().get(0);
                Dictionary<String> sourceDict = oldDicts.get(colRef);
                Dictionary<String> mergedDict = newDicts.get(colRef);
                BitmapCounter retValue = new BitmapCounter();
                byte[] literal = new byte[sourceDict.getSizeOfValue()];
                Iterator<Integer> iterator = value.iterator();
                while (iterator.hasNext()) {
                    int id = iterator.next();
                    int size = sourceDict.getValueBytesFromId(id, literal, 0);
                    int newId = size < 0 ? mergedDict.nullId() : mergedDict.getIdFromValueBytes(literal, 0, size);
                    retValue.add(newId);
                }
                return retValue;
            }
        };
    }

    @Override
    public MeasureAggregator<BitmapCounter> newAggregator() {
        return new BitmapAggregator();
    }

    @Override
    public List<TblColRef> getColumnsNeedDictionary(FunctionDesc functionDesc) {
        if (this.needDictionaryColumn(functionDesc)) {
            return Collections.singletonList(functionDesc.getParameter().getColRefs().get(0));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public Class<?> getRewriteCalciteAggrFunctionClass() {
        return BitmapDistinctCountAggFunc.class;
    }

    private boolean needDictionaryColumn(FunctionDesc functionDesc) {
        DataType dataType = functionDesc.getParameter().getColRefs().get(0).getType();
        return !dataType.isIntegerFamily() || dataType.isBigInt();
    }

    public static class Factory
    extends MeasureTypeFactory<BitmapCounter> {
        @Override
        public MeasureType<BitmapCounter> createMeasureType(String funcName, DataType dataType) {
            return new BitmapMeasureType(funcName, dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return BitmapMeasureType.FUNC_COUNT_DISTINCT;
        }

        @Override
        public String getAggrDataTypeName() {
            return BitmapMeasureType.DATATYPE_BITMAP;
        }

        @Override
        public Class<? extends DataTypeSerializer<BitmapCounter>> getAggrDataTypeSerializer() {
            return BitmapSerializer.class;
        }
    }
}

