/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BitmapCounter
implements Comparable<BitmapCounter> {
    private MutableRoaringBitmap bitmap = new MutableRoaringBitmap();

    public BitmapCounter() {
    }

    public BitmapCounter(BitmapCounter another) {
        this.merge(another);
    }

    public void clear() {
        this.bitmap.clear();
    }

    public void add(int value) {
        this.bitmap.add(value);
    }

    public void add(byte[] value) {
        this.add(value, 0, value.length);
    }

    public void add(byte[] value, int offset, int length) {
        if (value == null || length == 0) {
            return;
        }
        this.add(new String(value, offset, length));
    }

    public void add(String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.add(Integer.parseInt(value));
    }

    public void merge(BitmapCounter another) {
        this.bitmap.or(another.bitmap);
    }

    public long getCount() {
        return this.bitmap.getCardinality();
    }

    public int getMemBytes() {
        return this.bitmap.getSizeInBytes();
    }

    public Iterator<Integer> iterator() {
        return this.bitmap.iterator();
    }

    public void writeRegisters(ByteBuffer out) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.bitmap.runOptimize();
        this.bitmap.serialize(dos);
        dos.close();
        ByteBuffer bb = ByteBuffer.wrap(bos.toByteArray());
        out.put(bb);
    }

    public void readRegisters(ByteBuffer in) throws IOException {
        DataInputByteBuffer input = new DataInputByteBuffer();
        input.reset(in);
        this.bitmap.deserialize(input);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bitmap.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitmapCounter other = (BitmapCounter)obj;
        return this.bitmap.equals(other.bitmap);
    }

    @Override
    public int compareTo(BitmapCounter o) {
        long e2;
        if (o == null) {
            return 1;
        }
        long e1 = this.getCount();
        if (e1 == (e2 = o.getCount())) {
            return 0;
        }
        if (e1 > e2) {
            return 1;
        }
        return -1;
    }

    public int peekLength(ByteBuffer in) {
        int mark = in.position();
        DataInputByteBuffer input = new DataInputByteBuffer();
        input.reset(in);
        MutableRoaringBitmap bitmap = new MutableRoaringBitmap();
        try {
            bitmap.deserialize(input);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        int len = in.position() - mark;
        in.position(mark);
        return len;
    }

    static class DataInputByteBuffer
    extends DataInputStream {
        private Buffer buffers;

        public DataInputByteBuffer() {
            this(new Buffer());
        }

        private DataInputByteBuffer(Buffer buffers) {
            super(buffers);
            this.buffers = buffers;
        }

        public void reset(ByteBuffer ... input) {
            this.buffers.reset(input);
        }

        public ByteBuffer[] getData() {
            return this.buffers.getData();
        }

        public int getPosition() {
            return this.buffers.getPosition();
        }

        public int getLength() {
            return this.buffers.getLength();
        }

        private static class Buffer
        extends InputStream {
            private final byte[] scratch = new byte[1];
            ByteBuffer[] buffers = new ByteBuffer[0];
            int bidx;
            int pos;
            int length;

            private Buffer() {
            }

            @Override
            public int read() {
                return -1 == this.read(this.scratch, 0, 1) ? -1 : this.scratch[0] & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                int rem;
                if (this.bidx >= this.buffers.length) {
                    return -1;
                }
                int cur = 0;
                do {
                    rem = Math.min(len, this.buffers[this.bidx].remaining());
                    this.buffers[this.bidx].get(b, off, rem);
                    cur += rem;
                    off += rem;
                } while ((len -= rem) > 0 && ++this.bidx < this.buffers.length);
                this.pos += cur;
                return cur;
            }

            public void reset(ByteBuffer[] buffers) {
                this.length = 0;
                this.pos = 0;
                this.bidx = 0;
                this.buffers = buffers;
                ByteBuffer[] arr$ = buffers;
                int len$ = buffers.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ByteBuffer b = arr$[i$];
                    this.length += b.remaining();
                }
            }

            public int getPosition() {
                return this.pos;
            }

            public int getLength() {
                return this.length;
            }

            public ByteBuffer[] getData() {
                return this.buffers;
            }
        }
    }
}

