/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.basic;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.basic.BigDecimalIngester;
import org.apache.kylin.measure.basic.BigDecimalMaxAggregator;
import org.apache.kylin.measure.basic.BigDecimalMinAggregator;
import org.apache.kylin.measure.basic.BigDecimalSumAggregator;
import org.apache.kylin.measure.basic.DoubleIngester;
import org.apache.kylin.measure.basic.DoubleMaxAggregator;
import org.apache.kylin.measure.basic.DoubleMinAggregator;
import org.apache.kylin.measure.basic.DoubleSumAggregator;
import org.apache.kylin.measure.basic.LongIngester;
import org.apache.kylin.measure.basic.LongMaxAggregator;
import org.apache.kylin.measure.basic.LongMinAggregator;
import org.apache.kylin.measure.basic.LongSumAggregator;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.FunctionDesc;

public class BasicMeasureType
extends MeasureType {
    private final String funcName;
    private final DataType dataType;

    public BasicMeasureType(String funcName, DataType dataType) {
        this.funcName = funcName;
        this.dataType = dataType;
    }

    @Override
    public void validate(FunctionDesc functionDesc) throws IllegalArgumentException {
        DataType rtype = this.dataType;
        if (this.funcName.equals("SUM")) {
            if (!rtype.isNumberFamily()) {
                throw new IllegalArgumentException("Return type for function " + this.funcName + " must be one of " + DataType.NUMBER_FAMILY);
            }
        } else if (this.funcName.equals("COUNT")) {
            if (!rtype.isIntegerFamily()) {
                throw new IllegalArgumentException("Return type for function " + this.funcName + " must be one of " + DataType.INTEGER_FAMILY);
            }
        } else if (this.funcName.equals("MAX") || this.funcName.equals("MIN")) {
            if (!rtype.isNumberFamily()) {
                throw new IllegalArgumentException("Return type for function " + this.funcName + " must be one of " + DataType.NUMBER_FAMILY);
            }
        } else {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            if (!config.isQueryIgnoreUnknownFunction()) {
                throw new IllegalArgumentException("Unrecognized function: [" + this.funcName + "]");
            }
        }
    }

    public MeasureIngester<?> newIngester() {
        if (this.dataType.isIntegerFamily()) {
            return new LongIngester();
        }
        if (this.dataType.isDecimal()) {
            return new BigDecimalIngester();
        }
        if (this.dataType.isNumberFamily()) {
            return new DoubleIngester();
        }
        throw new IllegalArgumentException("No ingester for aggregation type " + this.dataType);
    }

    public MeasureAggregator<?> newAggregator() {
        if (this.isSum() || this.isCount()) {
            if (this.dataType.isDecimal()) {
                return new BigDecimalSumAggregator();
            }
            if (this.dataType.isIntegerFamily()) {
                return new LongSumAggregator();
            }
            if (this.dataType.isNumberFamily()) {
                return new DoubleSumAggregator();
            }
        } else if (this.isMax()) {
            if (this.dataType.isDecimal()) {
                return new BigDecimalMaxAggregator();
            }
            if (this.dataType.isIntegerFamily()) {
                return new LongMaxAggregator();
            }
            if (this.dataType.isNumberFamily()) {
                return new DoubleMaxAggregator();
            }
        } else if (this.isMin()) {
            if (this.dataType.isDecimal()) {
                return new BigDecimalMinAggregator();
            }
            if (this.dataType.isIntegerFamily()) {
                return new LongMinAggregator();
            }
            if (this.dataType.isNumberFamily()) {
                return new DoubleMinAggregator();
            }
        }
        throw new IllegalArgumentException("No aggregator for func '" + this.funcName + "' and return type '" + this.dataType + "'");
    }

    private boolean isSum() {
        return "SUM".equals(this.funcName);
    }

    private boolean isCount() {
        return "COUNT".equals(this.funcName);
    }

    private boolean isMax() {
        return "MAX".equals(this.funcName);
    }

    private boolean isMin() {
        return "MIN".equals(this.funcName);
    }

    @Override
    public boolean needRewrite() {
        return !this.isSum();
    }

    @Override
    public Class<?> getRewriteCalciteAggrFunctionClass() {
        return null;
    }

    public static class Factory
    extends MeasureTypeFactory {
        public MeasureType createMeasureType(String funcName, DataType dataType) {
            return new BasicMeasureType(funcName, dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return null;
        }

        @Override
        public String getAggrDataTypeName() {
            return null;
        }

        public Class getAggrDataTypeSerializer() {
            return null;
        }
    }
}

