/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.MeasureDesc;

public class MeasureDecoder {
    int nMeasures;
    DataTypeSerializer[] serializers;

    public MeasureDecoder(Collection<MeasureDesc> measureDescs) {
        this(measureDescs.toArray(new MeasureDesc[measureDescs.size()]));
    }

    public MeasureDecoder(MeasureDesc ... measureDescs) {
        String[] dataTypes = new String[measureDescs.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            dataTypes[i] = measureDescs[i].getFunction().getReturnType();
        }
        this.init(dataTypes);
    }

    public MeasureDecoder(DataType ... dataTypes) {
        this.init(dataTypes);
    }

    public MeasureDecoder(String ... dataTypes) {
        this.init(dataTypes);
    }

    private void init(String[] dataTypes) {
        DataType[] typeInstances = new DataType[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            typeInstances[i] = DataType.getType(dataTypes[i]);
        }
        this.init(typeInstances);
    }

    private void init(DataType[] dataTypes) {
        this.nMeasures = dataTypes.length;
        this.serializers = new DataTypeSerializer[this.nMeasures];
        for (int i = 0; i < this.nMeasures; ++i) {
            this.serializers[i] = DataTypeSerializer.create(dataTypes[i]);
        }
    }

    public DataTypeSerializer getSerializer(int idx) {
        return this.serializers[idx];
    }

    public int[] getPeekLength(ByteBuffer buf) {
        int[] length = new int[this.nMeasures];
        int offset = 0;
        for (int i = 0; i < this.nMeasures; ++i) {
            length[i] = this.serializers[i].peekLength(buf);
            buf.position(offset += length[i]);
        }
        return length;
    }

    public void decode(ByteBuffer buf, Object[] result) {
        assert (result.length == this.nMeasures);
        for (int i = 0; i < this.nMeasures; ++i) {
            result[i] = this.serializers[i].deserialize(buf);
        }
    }
}

