/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.apache.kylin.cube.ISegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.gridtable.EmptyGTScanner;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerWorker {
    private static final Logger logger = LoggerFactory.getLogger(ScannerWorker.class);
    private IGTScanner internal = null;

    public ScannerWorker(ISegment segment, Cuboid cuboid, GTScanRequest scanRequest, String gtStorage) {
        if (scanRequest == null) {
            logger.info("Segment {} will be skipped", (Object)segment);
            this.internal = new EmptyGTScanner(0L);
            return;
        }
        GTInfo info = scanRequest.getInfo();
        try {
            IGTStorage rpc = (IGTStorage)Class.forName(gtStorage).getConstructor(ISegment.class, Cuboid.class, GTInfo.class).newInstance(segment, cuboid, info);
            this.internal = rpc.getGTScanner(scanRequest);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Iterator<GTRecord> iterator() {
        return this.internal.iterator();
    }

    public void close() throws IOException {
        this.internal.close();
    }

    public long getScannedRowCount() {
        return this.internal.getScannedRowCount();
    }
}

