/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTUtil;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class GTFilterScanner
implements IGTScanner {
    private final IGTScanner inputScanner;
    private final TupleFilter filter;
    private final IFilterCodeSystem<ByteArray> filterCodeSystem;
    private final IEvaluatableTuple oneTuple;
    private GTRecord next = null;

    public GTFilterScanner(IGTScanner inputScanner, GTScanRequest req) throws IOException {
        this.inputScanner = inputScanner;
        this.filter = req.getFilterPushDown();
        this.filterCodeSystem = GTUtil.wrap(this.getInfo().codeSystem.getComparator());
        this.oneTuple = new IEvaluatableTuple(){

            @Override
            public Object getValue(TblColRef col) {
                return GTFilterScanner.this.next.get(col.getColumnDesc().getZeroBasedIndex());
            }
        };
        if (!TupleFilter.isEvaluableRecursively(this.filter)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public GTInfo getInfo() {
        return this.inputScanner.getInfo();
    }

    @Override
    public long getScannedRowCount() {
        return this.inputScanner.getScannedRowCount();
    }

    @Override
    public void close() throws IOException {
        this.inputScanner.close();
    }

    @Override
    public Iterator<GTRecord> iterator() {
        return new Iterator<GTRecord>(){
            private Iterator<GTRecord> inputIterator;
            private FilterResultCache resultCache;
            {
                this.inputIterator = GTFilterScanner.this.inputScanner.iterator();
                this.resultCache = new FilterResultCache(GTFilterScanner.this.getInfo(), GTFilterScanner.this.filter);
            }

            @Override
            public boolean hasNext() {
                if (GTFilterScanner.this.next != null) {
                    return true;
                }
                while (this.inputIterator.hasNext()) {
                    GTFilterScanner.this.next = this.inputIterator.next();
                    if (!this.evaluate()) continue;
                    return true;
                }
                GTFilterScanner.this.next = null;
                return false;
            }

            private boolean evaluate() {
                if (GTFilterScanner.this.filter == null) {
                    return true;
                }
                boolean[] cachedResult = this.resultCache.checkCache(GTFilterScanner.this.next);
                if (cachedResult != null) {
                    return cachedResult[0];
                }
                boolean result = GTFilterScanner.this.filter.evaluate(GTFilterScanner.this.oneTuple, GTFilterScanner.this.filterCodeSystem);
                this.resultCache.setLastResult(result);
                return result;
            }

            @Override
            public GTRecord next() {
                if (GTFilterScanner.this.next == null) {
                    this.hasNext();
                    if (GTFilterScanner.this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                GTRecord result = GTFilterScanner.this.next;
                GTFilterScanner.this.next = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static class FilterResultCache {
        static final int CHECKPOINT = 10000;
        static final double HIT_RATE_THRESHOLD = 0.5;
        public static boolean ENABLED = true;
        public boolean enabled = ENABLED;
        ImmutableBitSet colsInFilter;
        int count;
        int hit;
        byte[] lastValues;
        boolean[] lastResult;

        public FilterResultCache(GTInfo info, TupleFilter filter) {
            this.colsInFilter = this.collectColumnsInFilter(filter);
            this.lastValues = new byte[info.getMaxColumnLength(this.colsInFilter)];
            this.lastResult = new boolean[1];
        }

        public boolean[] checkCache(GTRecord record) {
            if (!this.enabled) {
                return null;
            }
            ++this.count;
            if (this.count == 10000 && (double)this.hit / (double)this.count < 0.5) {
                this.enabled = false;
            }
            boolean match = this.count > 1;
            int p = 0;
            for (int i = 0; i < this.colsInFilter.trueBitCount(); ++i) {
                int c = this.colsInFilter.trueBitAt(i);
                ByteArray col = record.get(c);
                if (match) {
                    boolean bl = match = BytesUtil.compareBytes(col.array(), col.offset(), this.lastValues, p, col.length()) == 0;
                }
                if (!match) {
                    System.arraycopy(col.array(), col.offset(), this.lastValues, p, col.length());
                }
                p += col.length();
            }
            if (match) {
                ++this.hit;
                return this.lastResult;
            }
            return null;
        }

        public void setLastResult(boolean evalResult) {
            this.lastResult[0] = evalResult;
        }

        private ImmutableBitSet collectColumnsInFilter(TupleFilter filter) {
            HashSet<TblColRef> columnsInFilter = new HashSet<TblColRef>();
            TupleFilter.collectColumns(filter, columnsInFilter);
            BitSet result = new BitSet();
            for (TblColRef col : columnsInFilter) {
                result.set(col.getColumnDesc().getZeroBasedIndex());
            }
            return new ImmutableBitSet(result);
        }
    }
}

