/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import org.apache.kylin.dimension.AbstractDateDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;

public class DateDimEnc
extends AbstractDateDimEnc {
    private static final long serialVersionUID = 1L;
    public static final int ID_9999_12_31 = 3652426;
    public static final String ENCODING_NAME = "date";

    public DateDimEnc() {
        super(3, new AbstractDateDimEnc.IMillisCodec(){
            private static final long serialVersionUID = 1L;

            @Override
            public long millisToCode(long millis) {
                return DateDimEnc.getNumOfDaysSince0000FromMillis(millis);
            }

            @Override
            public long codeToMillis(long code) {
                return DateDimEnc.getMillisFromNumOfDaysSince0000(code);
            }
        });
    }

    public static long getNumOfDaysSince0000FromMillis(long millis) {
        return (int)(millis / 86400000L + 719530L);
    }

    public static long getMillisFromNumOfDaysSince0000(long n) {
        long millis = (n - 719530L) * 86400000L;
        return millis;
    }

    public static class Factory
    extends DimensionEncodingFactory {
        @Override
        public String getSupportedEncodingName() {
            return DateDimEnc.ENCODING_NAME;
        }

        @Override
        public DimensionEncoding createDimensionEncoding(String encodingName, String[] args) {
            return new DateDimEnc();
        }
    }
}

