/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class AbstractDateDimEnc
extends DimensionEncoding {
    private static final long serialVersionUID = 1L;
    private int fixedLen;
    private IMillisCodec codec;

    protected AbstractDateDimEnc(int fixedLen, IMillisCodec codec) {
        this.fixedLen = fixedLen;
        this.codec = codec;
    }

    @Override
    public int getLengthOfEncoding() {
        return this.fixedLen;
    }

    @Override
    public void encode(byte[] value, int valueLen, byte[] output, int outputOffset) {
        if (value == null) {
            Arrays.fill(output, outputOffset, outputOffset + this.fixedLen, (byte)-1);
            return;
        }
        try {
            String str = new String(value, 0, valueLen, "ISO-8859-1");
            this.encode(str, output, outputOffset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    void encode(String value, byte[] output, int outputOffset) {
        if (value == null) {
            Arrays.fill(output, outputOffset, outputOffset + this.fixedLen, (byte)-1);
            return;
        }
        long millis = DateFormat.stringToMillis(value);
        long code = this.codec.millisToCode(millis);
        BytesUtil.writeLong(code, output, outputOffset, this.fixedLen);
    }

    @Override
    public String decode(byte[] bytes, int offset, int len) {
        if (AbstractDateDimEnc.isNull(bytes, offset, len)) {
            return null;
        }
        long code = BytesUtil.readLong(bytes, offset, this.fixedLen);
        if (code < 0L) {
            throw new IllegalArgumentException();
        }
        long millis = this.codec.codeToMillis(code);
        return String.valueOf(millis);
    }

    @Override
    public DataTypeSerializer<Object> asDataTypeSerializer() {
        return new DataTypeSerializer<Object>(){
            private ThreadLocal<byte[]> current = new ThreadLocal();

            private byte[] currentBuf() {
                byte[] buf = this.current.get();
                if (buf == null) {
                    buf = new byte[AbstractDateDimEnc.this.fixedLen];
                    this.current.set(buf);
                }
                return buf;
            }

            @Override
            public void serialize(Object value, ByteBuffer out) {
                byte[] buf = this.currentBuf();
                String valueStr = value == null ? null : value.toString();
                AbstractDateDimEnc.this.encode(valueStr, buf, 0);
                out.put(buf);
            }

            @Override
            public Object deserialize(ByteBuffer in) {
                byte[] buf = this.currentBuf();
                in.get(buf);
                return AbstractDateDimEnc.this.decode(buf, 0, buf.length);
            }

            @Override
            public int peekLength(ByteBuffer in) {
                return AbstractDateDimEnc.this.fixedLen;
            }

            @Override
            public int maxLength() {
                return AbstractDateDimEnc.this.fixedLen;
            }

            @Override
            public int getStorageBytesEstimate() {
                return AbstractDateDimEnc.this.fixedLen;
            }

            @Override
            public Object valueOf(String str) {
                return str;
            }
        };
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fixedLen);
        out.writeObject(this.codec);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fixedLen = in.readInt();
        this.codec = (IMillisCodec)in.readObject();
    }

    static interface IMillisCodec
    extends Serializable {
        public long millisToCode(long var1);

        public long codeToMillis(long var1);
    }
}

