/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.dict.lookup.SnapshotManager;
import org.apache.kylin.dict.lookup.SnapshotTable;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.SourceFactory;

public class SnapshotCLI {
    public static void main(String[] args) throws IOException {
        if ("rebuild".equals(args[0])) {
            SnapshotCLI.rebuild(args[1], args[2]);
        }
    }

    private static void rebuild(String table, String overwriteUUID) throws IOException {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        MetadataManager metaMgr = MetadataManager.getInstance(conf);
        SnapshotManager snapshotMgr = SnapshotManager.getInstance(conf);
        TableDesc tableDesc = metaMgr.getTableDesc(table);
        if (tableDesc == null) {
            throw new IllegalArgumentException("Not table found by " + table);
        }
        SnapshotTable snapshot = snapshotMgr.rebuildSnapshot(SourceFactory.createReadableTable(tableDesc), tableDesc, overwriteUUID);
        System.out.println("resource path updated: " + snapshot.getResourcePath());
    }
}

