/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Dictionary;

public class TimeStrDictionary
extends Dictionary<String> {
    private static final int MAX_ID = 0x7FFFFFFE;
    private static final int MAX_LENGTH_OF_POSITIVE_LONG = 19;

    @Override
    public int getMinId() {
        return 0;
    }

    @Override
    public int getMaxId() {
        return 0x7FFFFFFE;
    }

    @Override
    public int getSizeOfId() {
        return 4;
    }

    @Override
    public int getSizeOfValue() {
        return 19;
    }

    @Override
    protected int getIdFromValueImpl(String value, int roundingFlag) {
        long millis = DateFormat.stringToMillis(value);
        long seconds = millis / 1000L;
        if (seconds > 0x7FFFFFFEL) {
            return this.nullId();
        }
        if (seconds < 0L) {
            throw new IllegalArgumentException("Illegal value: " + value + ", parsed seconds: " + seconds);
        }
        return (int)seconds;
    }

    @Override
    protected String getValueFromIdImpl(int id) {
        if (id == this.nullId()) {
            return null;
        }
        long millis = 1000L * (long)id;
        return DateFormat.formatToTimeWithoutMilliStr(millis);
    }

    @Override
    protected final int getIdFromValueBytesImpl(byte[] value, int offset, int len, int roundingFlag) {
        try {
            return this.getIdFromValue(new String(value, offset, len, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected final byte[] getValueBytesFromIdImpl(int id) {
        byte[] bytes;
        String date = (String)this.getValueFromId(id);
        try {
            bytes = date.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return bytes;
    }

    @Override
    protected final int getValueBytesFromIdImpl(int id, byte[] returnValue, int offset) {
        byte[] bytes = this.getValueBytesFromIdImpl(id);
        System.arraycopy(bytes, 0, returnValue, offset, bytes.length);
        return bytes.length;
    }

    @Override
    public void dump(PrintStream out) {
        out.println(this.toString());
    }

    public String toString() {
        return "TimeStrDictionary supporting from 1970-01-01 00:00:00 to 2038/01/19 03:14:07 (does not support millisecond)";
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof TimeStrDictionary;
    }

    @Override
    public boolean contains(Dictionary<?> other) {
        return this.equals(other);
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }
}

