/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.IOException;
import java.util.Arrays;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.dict.IDictionaryValueEnumerator;
import org.apache.kylin.source.ReadableTable;

public class TableColumnValueEnumerator
implements IDictionaryValueEnumerator {
    private ReadableTable.TableReader reader;
    private int colIndex;
    private byte[] colValue;

    public TableColumnValueEnumerator(ReadableTable.TableReader reader, int colIndex) {
        this.reader = reader;
        this.colIndex = colIndex;
    }

    @Override
    public boolean moveNext() throws IOException {
        if (this.reader.next()) {
            String colStrValue;
            String[] split = this.reader.getRow();
            if (split.length == 1) {
                colStrValue = split[0];
            } else {
                if (split.length <= this.colIndex) {
                    throw new ArrayIndexOutOfBoundsException("Column no. " + this.colIndex + " not found, line split is " + Arrays.asList(split));
                }
                colStrValue = split[this.colIndex];
            }
            this.colValue = colStrValue == null ? null : Bytes.toBytes(colStrValue);
            return true;
        }
        this.colValue = null;
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public byte[] current() {
        return this.colValue;
    }
}

