/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.dict.NumberDictionaryBuilder;
import org.apache.kylin.dict.StringBytesConverter;
import org.apache.kylin.dict.TrieDictionary;

public class NumberDictionary<T>
extends TrieDictionary<T> {
    public static final int MAX_DIGITS_BEFORE_DECIMAL_POINT_LEGACY = 16;
    public static final int MAX_DIGITS_BEFORE_DECIMAL_POINT = 19;
    static ThreadLocal<NumberBytesCodec> localCodec = new ThreadLocal();

    public NumberDictionary() {
    }

    public NumberDictionary(byte[] trieBytes) {
        super(trieBytes);
    }

    protected NumberBytesCodec getCodec() {
        NumberBytesCodec codec = localCodec.get();
        if (codec == null) {
            codec = new NumberBytesCodec(16);
            localCodec.set(codec);
        }
        return codec;
    }

    @Override
    protected int getIdFromValueBytesImpl(byte[] value, int offset, int len, int roundingFlag) {
        NumberBytesCodec codec = this.getCodec();
        codec.encodeNumber(value, offset, len);
        return super.getIdFromValueBytesImpl(codec.buf, codec.bufOffset, codec.bufLen, roundingFlag);
    }

    @Override
    protected boolean isNullObjectForm(T value) {
        return value == null || value.equals("");
    }

    @Override
    protected int getValueBytesFromIdImpl(int id, byte[] returnValue, int offset) {
        NumberBytesCodec codec = this.getCodec();
        codec.bufOffset = 0;
        codec.bufLen = super.getValueBytesFromIdImpl(id, codec.buf, 0);
        return codec.decodeNumber(returnValue, offset);
    }

    @Override
    public void enableIdToValueBytesCache() {
        this.enableIdToValueBytesCache(new TrieDictionary.EnableIdToValueBytesCacheVisitor(){
            NumberBytesCodec codec;
            byte[] tmp;
            {
                this.codec = NumberDictionary.this.getCodec();
                this.tmp = new byte[NumberDictionary.this.getSizeOfValue()];
            }

            @Override
            public byte[] getBuffer() {
                return this.codec.buf;
            }

            @Override
            public byte[] makeValueBytes(byte[] buf, int length) {
                this.codec.bufOffset = 0;
                this.codec.bufLen = length;
                int numLen = this.codec.decodeNumber(this.tmp, 0);
                byte[] result = new byte[numLen];
                System.arraycopy(this.tmp, 0, result, 0, numLen);
                return result;
            }
        });
    }

    public static void main(String[] args) throws Exception {
        NumberDictionaryBuilder<String> b = new NumberDictionaryBuilder<String>(new StringBytesConverter());
        b.addValue("10");
        b.addValue("100");
        b.addValue("40");
        b.addValue("7");
        TrieDictionary dict = b.build(0);
        dict.enableIdToValueBytesCache();
        for (int i = 0; i <= dict.getMaxId(); ++i) {
            System.out.println(Bytes.toString(dict.getValueBytesFromId(i)));
        }
    }

    static class NumberBytesCodec {
        int maxDigitsBeforeDecimalPoint;
        byte[] buf;
        int bufOffset;
        int bufLen;

        NumberBytesCodec(int maxDigitsBeforeDecimalPoint) {
            this.maxDigitsBeforeDecimalPoint = maxDigitsBeforeDecimalPoint;
            this.buf = new byte[maxDigitsBeforeDecimalPoint * 3];
            this.bufOffset = 0;
            this.bufLen = 0;
        }

        void encodeNumber(byte[] value, int offset, int len) {
            int i;
            int nZeroPadding;
            if (len == 0) {
                this.bufOffset = 0;
                this.bufLen = 0;
                return;
            }
            if (len > this.buf.length) {
                throw new IllegalArgumentException("Too many digits for NumberDictionary: " + Bytes.toString(value, offset, len) + ". Internal buffer is only " + this.buf.length + " bytes");
            }
            boolean negative = value[offset] == 45;
            int start = this.buf.length - len;
            int end = this.buf.length;
            if (negative) {
                --start;
                this.buf[--end] = 59;
            }
            int decimalPoint = end;
            int i2 = start;
            int j = offset;
            while (i2 < end) {
                this.buf[i2] = value[j];
                if (this.buf[i2] == 46 && i2 < decimalPoint) {
                    decimalPoint = i2;
                }
                ++i2;
                ++j;
            }
            if (negative) {
                ++start;
            }
            if ((nZeroPadding = this.maxDigitsBeforeDecimalPoint - (decimalPoint - start)) < 0 || nZeroPadding + 1 > start) {
                throw new IllegalArgumentException("Too many digits for NumberDictionary: " + Bytes.toString(value, offset, len) + ". Expect " + this.maxDigitsBeforeDecimalPoint + " digits before decimal point at max.");
            }
            for (i = 0; i < nZeroPadding; ++i) {
                this.buf[--start] = 48;
            }
            if (negative) {
                this.buf[--start] = 45;
                for (i = start + 1; i < this.buf.length; ++i) {
                    byte c = this.buf[i];
                    if (c < 48 || c > 57) continue;
                    this.buf[i] = (byte)(57 - (c - 48));
                }
            } else {
                this.buf[--start] = 48;
            }
            this.bufOffset = start;
            this.bufLen = this.buf.length - start;
        }

        int decodeNumber(byte[] returnValue, int offset) {
            boolean negative;
            if (this.bufLen == 0) {
                return 0;
            }
            int in = this.bufOffset;
            int end = this.bufOffset + this.bufLen;
            int out = offset;
            boolean bl = negative = this.buf[in] == 45;
            if (negative) {
                returnValue[out++] = 45;
                ++in;
                --end;
            }
            byte padding = (byte)(negative ? 57 : 48);
            while (in < end && this.buf[in] == padding) {
                ++in;
            }
            if (in == end || this.buf[in] < 48 || this.buf[in] > 57) {
                returnValue[out++] = 48;
            }
            if (negative) {
                while (in < end) {
                    int c = this.buf[in];
                    if (c >= 48 && c <= 57) {
                        c = 57 - (c - 48);
                    }
                    returnValue[out] = (byte)c;
                    ++in;
                    ++out;
                }
            } else {
                System.arraycopy(this.buf, in, returnValue, out, end - in);
                out += end - in;
            }
            return out - offset;
        }
    }
}

