/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.DateStrDictionary;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.IDictionaryBuilder;
import org.apache.kylin.dict.IDictionaryValueEnumerator;
import org.apache.kylin.dict.MultipleDictionaryValueEnumerator;
import org.apache.kylin.dict.NumberDictionaryBuilder;
import org.apache.kylin.dict.StringBytesConverter;
import org.apache.kylin.dict.TimeStrDictionary;
import org.apache.kylin.dict.TrieDictionary;
import org.apache.kylin.dict.TrieDictionaryBuilder;
import org.apache.kylin.metadata.datatype.DataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryGenerator {
    private static final int DICT_MAX_CARDINALITY = DictionaryGenerator.getDictionaryMaxCardinality();
    private static final Logger logger = LoggerFactory.getLogger(DictionaryGenerator.class);
    private static final String[] DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyyMMdd"};

    private static int getDictionaryMaxCardinality() {
        try {
            return KylinConfig.getInstanceFromEnv().getDictionaryMaxCardinality();
        }
        catch (Throwable e) {
            return 30000000;
        }
    }

    public static Dictionary<String> buildDictionary(DataType dataType, IDictionaryValueEnumerator valueEnumerator) throws IOException {
        Preconditions.checkNotNull((Object)dataType, (Object)"dataType cannot be null");
        IDictionaryBuilder builder = dataType.isDateTimeFamily() ? (dataType.isDate() ? new DateDictBuilder() : new TimeDictBuilder()) : (dataType.isNumberFamily() ? new NumberDictBuilder() : new StringDictBuilder());
        return DictionaryGenerator.buildDictionary(builder, null, valueEnumerator);
    }

    public static Dictionary<String> buildDictionary(IDictionaryBuilder builder, DictionaryInfo dictInfo, IDictionaryValueEnumerator valueEnumerator) throws IOException {
        int baseId = 0;
        int nSamples = 5;
        ArrayList<String> samples = new ArrayList<String>(nSamples);
        Dictionary<String> dict = builder.build(dictInfo, valueEnumerator, baseId, nSamples, samples);
        StringBuilder buf = new StringBuilder();
        for (String s : samples) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(s.toString()).append("=>").append(dict.getIdFromValue(s));
        }
        logger.debug("Dictionary value samples: " + buf.toString());
        logger.debug("Dictionary cardinality: " + dict.getSize());
        logger.debug("Dictionary builder class: " + builder.getClass().getName());
        logger.debug("Dictionary class: " + dict.getClass().getName());
        if (dict instanceof TrieDictionary && dict.getSize() > DICT_MAX_CARDINALITY) {
            throw new IllegalArgumentException("Too high cardinality is not suitable for dictionary -- cardinality: " + dict.getSize());
        }
        return dict;
    }

    public static Dictionary mergeDictionaries(DataType dataType, List<DictionaryInfo> sourceDicts) throws IOException {
        return DictionaryGenerator.buildDictionary(dataType, new MultipleDictionaryValueEnumerator(sourceDicts));
    }

    private static class NumberDictBuilder
    implements IDictionaryBuilder {
        private NumberDictBuilder() {
        }

        @Override
        public Dictionary<String> build(DictionaryInfo dictInfo, IDictionaryValueEnumerator valueEnumerator, int baseId, int nSamples, ArrayList<String> returnSamples) throws IOException {
            NumberDictionaryBuilder<String> builder = new NumberDictionaryBuilder<String>(new StringBytesConverter());
            while (valueEnumerator.moveNext()) {
                String v;
                byte[] value = valueEnumerator.current();
                if (value == null || StringUtils.isBlank((String)(v = Bytes.toString(value)))) continue;
                builder.addValue(v);
                if (returnSamples.size() >= nSamples || returnSamples.contains(v)) continue;
                returnSamples.add(v);
            }
            return builder.build(baseId);
        }
    }

    private static class StringDictBuilder
    implements IDictionaryBuilder {
        private StringDictBuilder() {
        }

        @Override
        public Dictionary<String> build(DictionaryInfo dictInfo, IDictionaryValueEnumerator valueEnumerator, int baseId, int nSamples, ArrayList<String> returnSamples) throws IOException {
            TrieDictionaryBuilder<String> builder = new TrieDictionaryBuilder<String>(new StringBytesConverter());
            while (valueEnumerator.moveNext()) {
                byte[] value = valueEnumerator.current();
                if (value == null) continue;
                String v = Bytes.toString(value);
                builder.addValue(v);
                if (returnSamples.size() >= nSamples || returnSamples.contains(v)) continue;
                returnSamples.add(v);
            }
            return builder.build(baseId);
        }
    }

    private static class TimeDictBuilder
    implements IDictionaryBuilder {
        private TimeDictBuilder() {
        }

        @Override
        public Dictionary<String> build(DictionaryInfo dictInfo, IDictionaryValueEnumerator valueEnumerator, int baseId, int nSamples, ArrayList<String> returnSamples) throws IOException {
            return new TimeStrDictionary();
        }
    }

    private static class DateDictBuilder
    implements IDictionaryBuilder {
        private DateDictBuilder() {
        }

        @Override
        public Dictionary<String> build(DictionaryInfo dictInfo, IDictionaryValueEnumerator valueEnumerator, int baseId, int nSamples, ArrayList<String> returnSamples) throws IOException {
            boolean BAD_THRESHOLD = false;
            String matchPattern = null;
            String[] arr$ = DATE_PATTERNS;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String ptn;
                matchPattern = ptn = arr$[i$];
                int badCount = 0;
                SimpleDateFormat sdf = new SimpleDateFormat(ptn);
                while (valueEnumerator.moveNext()) {
                    byte[] value = valueEnumerator.current();
                    if (value == null || value.length == 0) continue;
                    String str = Bytes.toString(value);
                    try {
                        sdf.parse(str);
                        if (returnSamples.size() >= nSamples || returnSamples.contains(str)) continue;
                        returnSamples.add(str);
                    }
                    catch (ParseException e) {
                        logger.info("Unrecognized date value: " + str);
                        if (++badCount <= 0) continue;
                        matchPattern = null;
                        break;
                    }
                }
                if (matchPattern == null) continue;
                return new DateStrDictionary(matchPattern, baseId);
            }
            throw new IllegalStateException("Unrecognized datetime value");
        }
    }
}

