/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.upgrade.V1_5_1;

import java.io.IOException;
import java.util.List;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.upgrade.V1_5_1.CubeDescUpgrade_v_1_5_1;
import org.apache.kylin.cube.upgrade.common.CubeMetadataUpgrade;
import org.apache.kylin.cube.upgrade.common.MetadataVersionRefresher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeMetadataUpgrade_v_1_5_1
extends CubeMetadataUpgrade {
    private static final Logger logger = LoggerFactory.getLogger(CubeMetadataUpgrade_v_1_5_1.class);

    public CubeMetadataUpgrade_v_1_5_1(String newMetadataUrl) {
        super(newMetadataUrl);
    }

    @Override
    public void upgradeNonCompatibleMeta() {
        this.upgradeCubeDesc();
    }

    @Override
    public void upgradeCompatibleMeta() {
        this.upgradeVersion();
        this.clear();
        this.upgradeEngineTypeStorageType();
        this.upgradeSignature();
    }

    private void upgradeVersion() {
        MetadataVersionRefresher refresher = new MetadataVersionRefresher(this.store, "1.5.1");
        try {
            refresher.refresh();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to upgrade version number", e);
        }
    }

    private void upgradeCubeDesc() {
        List<String> paths = this.listResourceStore("/cube_desc");
        for (String path : paths) {
            logger.info("CubeMetadataUpgrade_v_1_5_1 handling in upgradeCubeDesc {}", (Object)path);
            try {
                CubeDescUpgrade_v_1_5_1 upgrade = new CubeDescUpgrade_v_1_5_1(path, this.store);
                CubeDesc ndesc = upgrade.upgrade();
                ResourceStore.getStore(this.config).putResource(ndesc.getResourcePath(), ndesc, CubeDescManager.CUBE_DESC_SERIALIZER);
                this.updatedResources.add(ndesc.getResourcePath());
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                this.errorMsgs.add("upgradeCubeDesc at '" + path + "' failed: " + e.getLocalizedMessage());
            }
        }
    }

    private void upgradeSignature() {
        CubeDescManager cubeDescManager = CubeDescManager.getInstance(this.config);
        List<CubeDesc> cubeDescs = cubeDescManager.listAllDesc();
        for (CubeDesc cubeDesc : cubeDescs) {
            logger.info("CubeMetadataUpgrade_v_1_5_1 handling in upgradeSignature {}", (Object)cubeDesc.getName());
            this.upgradeSignature(cubeDesc);
        }
    }

    private void upgradeSignature(CubeDesc cubeDesc) {
        try {
            String calculatedSign = cubeDesc.calculateSignature();
            if (cubeDesc.getSignature() == null || !cubeDesc.getSignature().equals(calculatedSign)) {
                cubeDesc.setSignature(calculatedSign);
                this.store.putResource(cubeDesc.getResourcePath(), cubeDesc, CubeDescManager.CUBE_DESC_SERIALIZER);
                this.updatedResources.add(cubeDesc.getResourcePath());
            }
        }
        catch (Exception e) {
            logger.error("error", (Throwable)e);
            this.errorMsgs.add("upgradeSignature [" + cubeDesc.getName() + "] failed: " + e.getLocalizedMessage());
        }
    }

    private void upgradeEngineTypeStorageType() {
        CubeManager cubeManager = CubeManager.getInstance(this.config);
        List<CubeInstance> cubes = cubeManager.listAllCubes();
        for (CubeInstance cube : cubes) {
            try {
                CubeDesc cubeDesc = cube.getDescriptor();
                if (cube.getFirstSegment() == null && cubeDesc != null && cubeDesc.getStorageType() == 0 && cubeDesc.getEngineType() == 0) {
                    logger.info("CubeMetadataUpgrade_v_1_5_1 handling in upgradeEngineTypeStorageType {}", (Object)cube.getName());
                    cubeDesc.setEngineType(2);
                    cubeDesc.setStorageType(2);
                    this.store.putResource(cubeDesc.getResourcePath(), cubeDesc, CubeDescManager.CUBE_DESC_SERIALIZER);
                    this.updatedResources.add(cubeDesc.getResourcePath());
                    continue;
                }
                logger.info("CubeDesc {}'s storage type and engine type will not be upgraded because they're not empty", (Object)cubeDesc.getName());
            }
            catch (Exception e) {
                logger.error("error", (Throwable)e);
                this.errorMsgs.add("upgradeEngineTypeStorageType [" + cube.getName() + "] failed: " + e.getLocalizedMessage());
            }
        }
    }
}

