/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation.rule;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ResultLevel;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableDesc;

public class FunctionRule
implements IValidatorRule<CubeDesc> {
    @Override
    public void validate(CubeDesc cube, ValidateContext context) {
        List<MeasureDesc> measures = cube.getMeasures();
        if (this.validateMeasureNamesDuplicated(measures, context)) {
            return;
        }
        ArrayList<FunctionDesc> countFuncs = new ArrayList<FunctionDesc>();
        for (MeasureDesc measure : measures) {
            FunctionDesc func = measure.getFunction();
            ParameterDesc parameter = func.getParameter();
            if (parameter == null) {
                context.addResult(ResultLevel.ERROR, "Must define parameter for function " + func.getExpression() + " in " + measure.getName());
                return;
            }
            String type = func.getParameter().getType();
            String value = func.getParameter().getValue();
            if (StringUtils.isEmpty((String)type)) {
                context.addResult(ResultLevel.ERROR, "Must define type for parameter type " + func.getExpression() + " in " + measure.getName());
                return;
            }
            if (StringUtils.isEmpty((String)value)) {
                context.addResult(ResultLevel.ERROR, "Must define type for parameter value " + func.getExpression() + " in " + measure.getName());
                return;
            }
            if (StringUtils.isEmpty((String)func.getReturnType())) {
                context.addResult(ResultLevel.ERROR, "Must define return type for function " + func.getExpression() + " in " + measure.getName());
                return;
            }
            if (StringUtils.equalsIgnoreCase((String)"column", (String)type)) {
                this.validateColumnParameter(context, cube, value);
            } else if (StringUtils.equals((String)"constant", (String)type)) {
                this.validateCostantParameter(context, cube, value);
            }
            try {
                func.getMeasureType().validate(func);
            }
            catch (IllegalArgumentException ex) {
                context.addResult(ResultLevel.ERROR, ex.getMessage());
            }
            if (func.isCount()) {
                countFuncs.add(func);
            }
            if (!"TOP_N".equalsIgnoreCase(func.getExpression())) continue;
            if (parameter.getNextParameter() == null) {
                context.addResult(ResultLevel.ERROR, "Must define at least 2 parameters for function " + func.getExpression() + " in " + measure.getName());
                return;
            }
            ArrayList duplicatedCol = Lists.newArrayList();
            for (ParameterDesc groupByCol = parameter.getNextParameter(); groupByCol != null; groupByCol = groupByCol.getNextParameter()) {
                String embeded_groupby = groupByCol.getValue();
                for (DimensionDesc dimensionDesc : cube.getDimensions()) {
                    if (dimensionDesc.getColumn() == null || !dimensionDesc.getColumn().equalsIgnoreCase(embeded_groupby)) continue;
                    duplicatedCol.add(embeded_groupby);
                }
            }
            if (duplicatedCol.size() <= 0) continue;
            context.addResult(ResultLevel.ERROR, "Couldn't use " + ((Object)duplicatedCol).toString() + " in Top-N as it is already defined as dimension.");
            return;
        }
        if (countFuncs.size() != 1) {
            context.addResult(ResultLevel.ERROR, "Must define one and only one count(1) function, but there are " + countFuncs.size() + " -- " + countFuncs);
        }
    }

    private void validateCostantParameter(ValidateContext context, CubeDesc cube, String value) {
        try {
            Integer.parseInt(value);
        }
        catch (Exception e) {
            context.addResult(ResultLevel.ERROR, "Parameter value must be number, but it is " + value);
        }
    }

    private void validateColumnParameter(ValidateContext context, CubeDesc cube, String value) {
        String factTable = cube.getFactTable();
        if (StringUtils.isEmpty((String)factTable)) {
            context.addResult(ResultLevel.ERROR, "Fact table can not be null.");
            return;
        }
        TableDesc table = MetadataManager.getInstance(cube.getConfig()).getTableDesc(factTable);
        if (table == null) {
            context.addResult(ResultLevel.ERROR, "Fact table can not be found: " + cube);
            return;
        }
        HashSet<String> set = new HashSet<String>();
        ColumnDesc[] cdesc = table.getColumns();
        for (int i = 0; i < cdesc.length; ++i) {
            ColumnDesc columnDesc = cdesc[i];
            set.add(columnDesc.getName());
        }
        String[] items = value.split(",");
        for (int i = 0; i < items.length; ++i) {
            String item = items[i].trim();
            if (StringUtils.isEmpty((String)item) || set.contains(item)) continue;
            context.addResult(ResultLevel.ERROR, "Column [" + item + "] does not exist in factable table" + factTable);
        }
    }

    private boolean validateMeasureNamesDuplicated(List<MeasureDesc> measures, ValidateContext context) {
        HashSet<String> nameSet = new HashSet<String>();
        for (MeasureDesc measure : measures) {
            if (nameSet.contains(measure.getName())) {
                context.addResult(ResultLevel.ERROR, "There is duplicated measure's name: " + measure.getName());
                return true;
            }
            nameSet.add(measure.getName());
        }
        return false;
    }
}

