/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation.rule;

import java.util.HashMap;
import java.util.List;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ResultLevel;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.metadata.model.TblColRef;

public class DictionaryRule
implements IValidatorRule<CubeDesc> {
    @Override
    public void validate(CubeDesc cubeDesc, ValidateContext context) {
        List<DictionaryDesc> dictDescs = cubeDesc.getDictionaries();
        if (dictDescs == null || dictDescs.isEmpty()) {
            return;
        }
        HashMap<TblColRef, String> colToBuilderMap = new HashMap<TblColRef, String>();
        HashMap<TblColRef, TblColRef> colToReuseColMap = new HashMap<TblColRef, TblColRef>();
        for (DictionaryDesc dictDesc : dictDescs) {
            TblColRef dictCol = dictDesc.getColumnRef();
            if (dictCol == null) {
                context.addResult(ResultLevel.ERROR, "Some column in dictionaries not found");
                return;
            }
            String builder = dictDesc.getBuilderClass();
            TblColRef reuseCol = dictDesc.getResuseColumnRef();
            if (reuseCol == null) {
                if (builder == null || builder.isEmpty()) {
                    context.addResult(ResultLevel.ERROR, "Column " + dictCol + " cannot have builder and reuse column both empty");
                    return;
                }
                String oldBuilder = colToBuilderMap.put(dictCol, builder);
                if (oldBuilder == null || oldBuilder.equals(builder)) continue;
                context.addResult(ResultLevel.ERROR, "Column " + dictCol + " has inconsistent builders " + builder + " and " + oldBuilder);
                return;
            }
            if (builder != null && !builder.isEmpty()) {
                context.addResult(ResultLevel.ERROR, "Column " + dictCol + " cannot have builder and reuse column both");
                return;
            }
            TblColRef oldReuseCol = colToReuseColMap.put(dictCol, reuseCol);
            if (oldReuseCol == null || reuseCol.equals(oldReuseCol)) continue;
            context.addResult(ResultLevel.ERROR, "Column " + dictCol + " reuse inconsistent column " + reuseCol + " and " + oldReuseCol);
            return;
        }
    }
}

