/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation;

import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.cube.model.validation.rule.AggregationGroupRule;
import org.apache.kylin.cube.model.validation.rule.DictionaryRule;
import org.apache.kylin.cube.model.validation.rule.FunctionRule;
import org.apache.kylin.cube.model.validation.rule.RowKeyAttrRule;

public class CubeMetadataValidator {
    private IValidatorRule<CubeDesc>[] rules = new IValidatorRule[]{new FunctionRule(), new AggregationGroupRule(), new RowKeyAttrRule(), new DictionaryRule()};

    public ValidateContext validate(CubeDesc cube) {
        return this.validate(cube, false);
    }

    public ValidateContext validate(CubeDesc cube, boolean inject) {
        ValidateContext context = new ValidateContext();
        for (int i = 0; i < this.rules.length; ++i) {
            IValidatorRule<CubeDesc> rule = this.rules[i];
            rule.validate(cube, context);
        }
        if (inject) {
            this.injectResult(cube, context);
        }
        return context;
    }

    public void injectResult(CubeDesc cubeDesc, ValidateContext context) {
        ValidateContext.Result[] results = context.getResults();
        for (int i = 0; i < results.length; ++i) {
            ValidateContext.Result result = results[i];
            cubeDesc.addError((Object)((Object)result.getLevel()) + " : " + result.getMessage(), true);
        }
    }
}

