/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.v1_4_0;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.model.v1_4_0.CubeDesc;
import org.apache.kylin.cube.model.v1_4_0.DimensionDesc;
import org.apache.kylin.cube.model.v1_4_0.HierarchyDesc;
import org.apache.kylin.cube.model.v1_4_0.RowKeyColDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class RowKeyDesc {
    @JsonProperty(value="rowkey_columns")
    private RowKeyColDesc[] rowkeyColumns;
    @JsonProperty(value="aggregation_groups")
    private String[][] aggregationGroups;
    private CubeDesc cubeDesc;
    private Map<TblColRef, RowKeyColDesc> columnMap;
    private long fullMask;
    private long mandatoryColumnMask;
    private AggrGroupMask[] aggrGroupMasks;
    private long aggrGroupFullMask;
    private long hierarchyFullMask;
    private long tailMask;
    private List<HierarchyMask> hierarchyMasks;

    public RowKeyColDesc[] getRowKeyColumns() {
        return this.rowkeyColumns;
    }

    public int getRowKeyIndexByColumnName(String columnName) {
        if (this.rowkeyColumns == null) {
            return -1;
        }
        for (int i = 0; i < this.rowkeyColumns.length; ++i) {
            RowKeyColDesc desc = this.rowkeyColumns[i];
            if (!desc.getColumn().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public int getNCuboidBuildLevels() {
        HashSet<String> aggDims = new HashSet<String>();
        String[][] arr$ = this.aggregationGroups;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] aggrGroup;
            for (String dim : aggrGroup = arr$[i$]) {
                aggDims.add(dim);
            }
        }
        return aggDims.size();
    }

    public String[][] getAggregationGroups() {
        return this.aggregationGroups;
    }

    public CubeDesc getCubeRef() {
        return this.cubeDesc;
    }

    public void setCubeRef(CubeDesc cubeRef) {
        this.cubeDesc = cubeRef;
    }

    public long getFullMask() {
        return this.fullMask;
    }

    public long getMandatoryColumnMask() {
        return this.mandatoryColumnMask;
    }

    public long getAggrGroupFullMask() {
        return this.aggrGroupFullMask;
    }

    public AggrGroupMask[] getAggrGroupMasks() {
        return this.aggrGroupMasks;
    }

    public List<HierarchyMask> getHierarchyMasks() {
        return this.hierarchyMasks;
    }

    public long getHierarchyFullMask() {
        return this.hierarchyFullMask;
    }

    public long getTailMask() {
        return this.tailMask;
    }

    public int getColumnBitIndex(TblColRef col) {
        return this.getColDesc(col).getBitIndex();
    }

    public int getColumnLength(TblColRef col) {
        return this.getColDesc(col).getLength();
    }

    public String getDictionary(TblColRef col) {
        return this.getColDesc(col).getDictionary();
    }

    private RowKeyColDesc getColDesc(TblColRef col) {
        RowKeyColDesc desc = this.columnMap.get(col);
        if (desc == null) {
            throw new NullPointerException("Column " + col + " does not exist in row key desc");
        }
        return desc;
    }

    public boolean isUseDictionary(int index) {
        String useDictionary = this.rowkeyColumns[index].getDictionary();
        return this.useDictionary(useDictionary);
    }

    public boolean isUseDictionary(TblColRef col) {
        String useDictionary = this.getDictionary(col);
        return this.useDictionary(useDictionary);
    }

    private boolean useDictionary(String useDictionary) {
        return !StringUtils.isBlank((String)useDictionary) && !"false".equals(useDictionary);
    }

    public void init(CubeDesc cube) {
        this.setCubeRef(cube);
        Map<String, TblColRef> colNameAbbr = cube.buildColumnNameAbbreviation();
        this.buildRowKey(colNameAbbr);
        this.buildAggregationGroups(colNameAbbr);
        this.buildHierarchyMasks();
    }

    public String toString() {
        return "RowKeyDesc [rowkeyColumns=" + Arrays.toString(this.rowkeyColumns) + ", aggregationGroups=" + Arrays.toString((Object[])this.aggregationGroups) + "]";
    }

    private void buildRowKey(Map<String, TblColRef> colNameAbbr) {
        this.columnMap = new HashMap<TblColRef, RowKeyColDesc>();
        this.mandatoryColumnMask = 0L;
        for (int i = 0; i < this.rowkeyColumns.length; ++i) {
            RowKeyColDesc rowKeyColDesc = this.rowkeyColumns[i];
            String column = rowKeyColDesc.getColumn();
            rowKeyColDesc.setColumn(column.toUpperCase());
            rowKeyColDesc.setBitIndex(this.rowkeyColumns.length - i - 1);
            rowKeyColDesc.setColRef(colNameAbbr.get(column));
            if (rowKeyColDesc.getColRef() == null) {
                throw new IllegalArgumentException("Cannot find rowkey column " + column + " in cube " + this.cubeDesc);
            }
            this.columnMap.put(rowKeyColDesc.getColRef(), rowKeyColDesc);
            if (!rowKeyColDesc.isMandatory()) continue;
            this.mandatoryColumnMask |= 1L << rowKeyColDesc.getBitIndex();
        }
    }

    private void buildAggregationGroups(Map<String, TblColRef> colNameAbbr) {
        int i;
        if (this.aggregationGroups == null) {
            this.aggregationGroups = new String[0][];
        }
        for (i = 0; i < this.aggregationGroups.length; ++i) {
            StringUtil.toUpperCaseArray(this.aggregationGroups[i], this.aggregationGroups[i]);
        }
        for (i = 0; i < this.rowkeyColumns.length; ++i) {
            int index = this.rowkeyColumns[i].getBitIndex();
            this.fullMask |= 1L << index;
        }
        this.aggrGroupMasks = new AggrGroupMask[this.aggregationGroups.length];
        for (i = 0; i < this.aggregationGroups.length; ++i) {
            String[] aggGrp = this.aggregationGroups[i];
            AggrGroupMask mask = new AggrGroupMask(aggGrp.length);
            for (int j = 0; j < aggGrp.length; ++j) {
                TblColRef aggCol = colNameAbbr.get(aggGrp[j].toUpperCase());
                if (aggCol == null) {
                    throw new IllegalArgumentException("Can't find aggregation column " + aggGrp[j] + " in  cube " + this.cubeDesc.getName());
                }
                Integer index = this.getColumnBitIndex(aggCol);
                mask.groupMask |= 1L << index;
                mask.groupOneBitMasks[j] = 1L << index;
                this.aggrGroupFullMask |= 1L << index;
            }
            this.aggrGroupMasks[i] = mask;
        }
        this.tailMask = this.fullMask ^ this.mandatoryColumnMask ^ this.aggrGroupFullMask;
        for (i = 0; i < this.aggrGroupMasks.length; ++i) {
            int j;
            AggrGroupMask mask = this.aggrGroupMasks[i];
            mask.uniqueMask = mask.groupMask;
            for (j = i + 1; j < this.aggrGroupMasks.length; ++j) {
                mask.uniqueMask &= this.aggrGroupMasks[j].groupMask ^ 0xFFFFFFFFFFFFFFFFL;
            }
            mask.leftoverMask = this.tailMask;
            for (j = i + 1; j < this.aggrGroupMasks.length; ++j) {
                mask.leftoverMask |= this.aggrGroupMasks[j].groupMask;
            }
            mask.leftoverMask &= mask.groupMask ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    private void buildHierarchyMasks() {
        this.hierarchyMasks = new ArrayList<HierarchyMask>();
        for (DimensionDesc dimension : this.cubeDesc.getDimensions()) {
            int i;
            HierarchyDesc[] hierarchies = dimension.getHierarchy();
            if (hierarchies == null || hierarchies.length == 0) continue;
            HierarchyMask mask = new HierarchyMask();
            ArrayList<Long> allMaskList = new ArrayList<Long>();
            for (i = 0; i < hierarchies.length; ++i) {
                TblColRef hColumn = hierarchies[i].getColumnRef();
                Integer index = this.getColumnBitIndex(hColumn);
                long bit = 1L << index;
                if ((this.tailMask & bit) > 0L) continue;
                mask.fullMask |= bit;
                this.hierarchyFullMask |= bit;
                allMaskList.add(mask.fullMask);
            }
            mask.allMasks = new long[allMaskList.size()];
            for (i = 0; i < allMaskList.size(); ++i) {
                mask.allMasks[i] = (Long)allMaskList.get(i);
            }
            this.hierarchyMasks.add(mask);
        }
    }

    public static class AggrGroupMask {
        public long groupMask;
        public long[] groupOneBitMasks;
        public long uniqueMask;
        public long leftoverMask;

        public AggrGroupMask(int size) {
            this.groupOneBitMasks = new long[size];
        }
    }

    public static class HierarchyMask {
        public long fullMask;
        public long[] allMasks;
    }
}

