/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.v1_4_0;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.model.v1_4_0.CubeDesc;
import org.apache.kylin.cube.model.v1_4_0.HBaseColumnDesc;
import org.apache.kylin.cube.model.v1_4_0.HBaseColumnFamilyDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class HBaseMappingDesc {
    @JsonProperty(value="column_family")
    private HBaseColumnFamilyDesc[] columnFamily;
    private CubeDesc cubeRef;

    public Collection<HBaseColumnDesc> findHBaseColumnByFunction(FunctionDesc function) {
        LinkedList<HBaseColumnDesc> result = new LinkedList<HBaseColumnDesc>();
        HBaseMappingDesc hbaseMapping = this.cubeRef.getHBaseMapping();
        if (hbaseMapping == null || hbaseMapping.getColumnFamily() == null) {
            return result;
        }
        for (HBaseColumnFamilyDesc cf : hbaseMapping.getColumnFamily()) {
            for (HBaseColumnDesc c : cf.getColumns()) {
                for (MeasureDesc m : c.getMeasures()) {
                    if (!m.getFunction().equals(function)) continue;
                    result.add(c);
                }
            }
        }
        return result;
    }

    public CubeDesc getCubeRef() {
        return this.cubeRef;
    }

    public void setCubeRef(CubeDesc cubeRef) {
        this.cubeRef = cubeRef;
    }

    public HBaseColumnFamilyDesc[] getColumnFamily() {
        return this.columnFamily;
    }

    public void setColumnFamily(HBaseColumnFamilyDesc[] columnFamily) {
        this.columnFamily = columnFamily;
    }

    public void init(CubeDesc cubeDesc) {
        this.cubeRef = cubeDesc;
        for (HBaseColumnFamilyDesc cf : this.columnFamily) {
            cf.setName(cf.getName().toUpperCase());
            for (HBaseColumnDesc c : cf.getColumns()) {
                c.setQualifier(c.getQualifier().toUpperCase());
                StringUtil.toUpperCaseArray(c.getMeasureRefs(), c.getMeasureRefs());
            }
        }
    }

    public String toString() {
        return "HBaseMappingDesc [columnFamily=" + Arrays.toString(this.columnFamily) + "]";
    }
}

