/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.v1_4_0;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.model.v1_4_0.CubeDesc;
import org.apache.kylin.cube.model.v1_4_0.HierarchyDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.LookupDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DimensionDesc {
    @JsonProperty(value="id")
    private int id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="hierarchy")
    private boolean isHierarchy;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="column")
    private String[] column;
    @JsonProperty(value="derived")
    private String[] derived;
    private TableDesc tableDesc;
    private JoinDesc join;
    private HierarchyDesc[] hierarchy;
    private TblColRef[] columnRefs;
    private TblColRef[] derivedColRefs;

    public void init(CubeDesc cubeDesc, Map<String, TableDesc> tables) {
        if (this.name != null) {
            this.name = this.name.toUpperCase();
        }
        if (this.table != null) {
            this.table = this.table.toUpperCase();
        }
        this.tableDesc = tables.get(this.getTable());
        if (this.tableDesc == null) {
            throw new IllegalStateException("Can't find table " + this.table + " for dimension " + this.name);
        }
        this.join = null;
        for (LookupDesc lookup : cubeDesc.getModel().getLookups()) {
            if (!lookup.getTable().equalsIgnoreCase(this.getTable())) continue;
            this.join = lookup.getJoin();
            break;
        }
        if (this.isHierarchy && this.column.length > 0) {
            ArrayList<HierarchyDesc> hierarchyList = new ArrayList<HierarchyDesc>(3);
            int n = this.column.length;
            for (int i = 0; i < n; ++i) {
                String aColumn = this.column[i];
                HierarchyDesc aHierarchy = new HierarchyDesc();
                aHierarchy.setLevel(String.valueOf(i + 1));
                aHierarchy.setColumn(aColumn);
                hierarchyList.add(aHierarchy);
            }
            this.hierarchy = hierarchyList.toArray(new HierarchyDesc[hierarchyList.size()]);
        }
        if (this.hierarchy != null && this.hierarchy.length == 0) {
            this.hierarchy = null;
        }
        if (this.derived != null && this.derived.length == 0) {
            this.derived = null;
        }
        if (this.hierarchy != null) {
            for (HierarchyDesc h : this.hierarchy) {
                h.setColumn(h.getColumn().toUpperCase());
            }
        }
        if (this.derived != null) {
            StringUtil.toUpperCaseArray(this.derived, this.derived);
        }
        if (this.derived != null && this.join == null) {
            throw new IllegalStateException("Derived can only be defined on lookup table, cube " + cubeDesc + ", " + this);
        }
    }

    public boolean isHierarchyColumn(TblColRef col) {
        if (this.hierarchy == null) {
            return false;
        }
        for (HierarchyDesc hier : this.hierarchy) {
            if (!hier.getColumnRef().equals(col)) continue;
            return true;
        }
        return false;
    }

    public boolean isDerived() {
        return this.derived != null;
    }

    public boolean isHierarchy() {
        return this.isHierarchy;
    }

    public void setHierarchy(boolean isHierarchy) {
        this.isHierarchy = isHierarchy;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public JoinDesc getJoin() {
        return this.join;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TblColRef[] getColumnRefs() {
        return this.columnRefs;
    }

    public void setColumnRefs(TblColRef[] colRefs) {
        this.columnRefs = colRefs;
    }

    public String[] getColumn() {
        return this.column;
    }

    public void setColumn(String[] column) {
        this.column = column;
    }

    public HierarchyDesc[] getHierarchy() {
        return this.hierarchy;
    }

    public void setHierarchy(HierarchyDesc[] hierarchy) {
        this.hierarchy = hierarchy;
    }

    public String[] getDerived() {
        return this.derived;
    }

    public void setDerived(String[] derived) {
        this.derived = derived;
    }

    public TblColRef[] getDerivedColRefs() {
        return this.derivedColRefs;
    }

    public void setDerivedColRefs(TblColRef[] derivedColRefs) {
        this.derivedColRefs = derivedColRefs;
    }

    public TableDesc getTableDesc() {
        return this.tableDesc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionDesc that = (DimensionDesc)o;
        if (this.id != that.id) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "DimensionDesc [name=" + this.name + ", join=" + this.join + ", hierarchy=" + Arrays.toString(this.hierarchy) + ", table=" + this.table + ", column=" + Arrays.toString(this.column) + ", derived=" + Arrays.toString(this.derived) + "]";
    }
}

