/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class RowKeyColDesc {
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="encoding")
    private String encoding;
    @JsonProperty(value="isShardBy")
    private boolean isShardBy;
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String index;
    private String encodingName;
    private String[] encodingArgs;
    private int bitIndex;
    private TblColRef colRef;

    public void init(int index, Map<String, TblColRef> colNameAbbr, CubeDesc cubeDesc) {
        this.column = this.column.toUpperCase();
        this.bitIndex = index;
        this.colRef = colNameAbbr.get(this.column);
        if (this.colRef == null) {
            throw new IllegalArgumentException("Cannot find rowkey column " + this.column + " in cube " + cubeDesc);
        }
        Preconditions.checkState((boolean)StringUtils.isNotEmpty((String)this.encoding));
        Object[] encodingConf = DimensionEncoding.parseEncodingConf(this.encoding);
        this.encodingName = (String)encodingConf[0];
        this.encodingArgs = (String[])encodingConf[1];
        if (!DimensionEncodingFactory.isVaildEncoding(this.encodingName)) {
            throw new IllegalArgumentException("Not supported row key col encoding: '" + this.encoding + "'");
        }
        DataType type = this.colRef.getType();
        if ("dict".equals(this.encodingName)) {
            if (type.isDate()) {
                this.encodingName = "date";
                this.encoding = "date";
            }
            if (type.isTimeFamily()) {
                this.encodingName = "time";
                this.encoding = "time";
            }
        }
        if ("date".equals(this.encodingName) && !type.isDate()) {
            throw new IllegalArgumentException(this.colRef + " type is " + type + " and cannot apply date encoding");
        }
        if ("time".equals(this.encodingName) && !type.isTimeFamily()) {
            throw new IllegalArgumentException(this.colRef + " type is " + type + " and cannot apply time encoding");
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public boolean isShardBy() {
        return this.isShardBy;
    }

    public void setShardBy(boolean shardBy) {
        this.isShardBy = shardBy;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public String[] getEncodingArgs() {
        return this.encodingArgs;
    }

    public boolean isUsingDictionary() {
        return "dict".equals(this.encodingName);
    }

    public int getBitIndex() {
        return this.bitIndex;
    }

    public TblColRef getColRef() {
        return this.colRef;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("column", (Object)this.column).add("encoding", (Object)this.encoding).toString();
    }
}

