/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TblColRef;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DictionaryDesc {
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="reuse")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String reuseColumn;
    @JsonProperty(value="builder")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String builderClass;
    private TblColRef colRef;
    private TblColRef reuseColRef;

    void init(CubeDesc cubeDesc) {
        DataModelDesc model = cubeDesc.getModel();
        this.column = this.column.toUpperCase();
        this.colRef = model.findColumn(this.column).getRef();
        if (this.reuseColumn != null) {
            this.reuseColumn = this.reuseColumn.toUpperCase();
            this.reuseColRef = model.findColumn(this.reuseColumn).getRef();
        }
    }

    public TblColRef getColumnRef() {
        return this.colRef;
    }

    public TblColRef getResuseColumnRef() {
        return this.reuseColRef;
    }

    public String getBuilderClass() {
        return this.builderClass;
    }

    public static DictionaryDesc create(String column, String reuseColumn, String builderClass) {
        DictionaryDesc desc = new DictionaryDesc();
        desc.column = column;
        desc.reuseColumn = reuseColumn;
        desc.builderClass = builderClass;
        return desc;
    }
}

