/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import java.util.List;
import org.apache.kylin.common.util.BytesSplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class CubeJoinedFlatTableEnrich
implements IJoinedFlatTableDesc {
    private CubeDesc cubeDesc;
    private IJoinedFlatTableDesc flatDesc;
    private int[] rowKeyColumnIndexes;
    private int[][] measureColumnIndexes;

    public CubeJoinedFlatTableEnrich(IJoinedFlatTableDesc flatDesc, CubeDesc cubeDesc) {
        if (cubeDesc.getModel() != flatDesc.getDataModel()) {
            throw new IllegalArgumentException();
        }
        this.cubeDesc = cubeDesc;
        this.flatDesc = flatDesc;
        this.parseCubeDesc();
    }

    private void parseCubeDesc() {
        long baseCuboidId = Cuboid.getBaseCuboidId(this.cubeDesc);
        Cuboid baseCuboid = Cuboid.findById(this.cubeDesc, baseCuboidId);
        List<TblColRef> cuboidColumns = baseCuboid.getColumns();
        int rowkeyColCount = this.cubeDesc.getRowkey().getRowKeyColumns().length;
        this.rowKeyColumnIndexes = new int[rowkeyColCount];
        for (int i = 0; i < rowkeyColCount; ++i) {
            TblColRef col = cuboidColumns.get(i);
            this.rowKeyColumnIndexes[i] = this.flatDesc.getColumnIndex(col);
        }
        List<MeasureDesc> measures = this.cubeDesc.getMeasures();
        int measureSize = measures.size();
        this.measureColumnIndexes = new int[measureSize][];
        for (int i = 0; i < measureSize; ++i) {
            FunctionDesc func = measures.get(i).getFunction();
            List<TblColRef> colRefs = func.getParameter().getColRefs();
            if (colRefs == null) {
                this.measureColumnIndexes[i] = null;
                continue;
            }
            this.measureColumnIndexes[i] = new int[colRefs.size()];
            for (int j = 0; j < colRefs.size(); ++j) {
                TblColRef c = colRefs.get(j);
                this.measureColumnIndexes[i][j] = this.flatDesc.getColumnIndex(c);
            }
        }
    }

    public void sanityCheck(BytesSplitter bytesSplitter) {
        int columnCount = this.flatDesc.getAllColumns().size();
        if (columnCount != bytesSplitter.getBufferSize()) {
            throw new IllegalArgumentException("Expect " + columnCount + " columns, but see " + bytesSplitter.getBufferSize() + " -- " + bytesSplitter);
        }
    }

    public CubeDesc getCubeDesc() {
        return this.cubeDesc;
    }

    public int[] getRowKeyColumnIndexes() {
        return this.rowKeyColumnIndexes;
    }

    public int[][] getMeasureColumnIndexes() {
        return this.measureColumnIndexes;
    }

    @Override
    public String getTableName() {
        return this.flatDesc.getTableName();
    }

    @Override
    public List<TblColRef> getAllColumns() {
        return this.flatDesc.getAllColumns();
    }

    @Override
    public DataModelDesc getDataModel() {
        return this.flatDesc.getDataModel();
    }

    @Override
    public int getColumnIndex(TblColRef colRef) {
        return this.flatDesc.getColumnIndex(colRef);
    }

    @Override
    public long getSourceOffsetStart() {
        return this.flatDesc.getSourceOffsetStart();
    }

    @Override
    public long getSourceOffsetEnd() {
        return this.flatDesc.getSourceOffsetEnd();
    }

    @Override
    public TblColRef getDistributedBy() {
        return this.flatDesc.getDistributedBy();
    }
}

