/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.BytesSplitter;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.DictionaryDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class CubeJoinedFlatTableDesc
implements IJoinedFlatTableDesc {
    private String tableName;
    private final CubeDesc cubeDesc;
    private final CubeSegment cubeSegment;
    private int columnCount;
    private List<TblColRef> columnList = Lists.newArrayList();
    private Map<TblColRef, Integer> columnIndexMap;

    public CubeJoinedFlatTableDesc(CubeDesc cubeDesc) {
        this(cubeDesc, null);
    }

    public CubeJoinedFlatTableDesc(CubeSegment cubeSegment) {
        this(cubeSegment.getCubeDesc(), cubeSegment);
    }

    private CubeJoinedFlatTableDesc(CubeDesc cubeDesc, CubeSegment cubeSegment) {
        this.cubeDesc = cubeDesc;
        this.cubeSegment = cubeSegment;
        this.columnIndexMap = Maps.newHashMap();
        this.parseCubeDesc();
    }

    private void parseCubeDesc() {
        this.tableName = this.cubeSegment == null ? "kylin_intermediate_" + this.cubeDesc.getName() : "kylin_intermediate_" + this.cubeDesc.getName() + "_" + this.cubeSegment.getUuid().replaceAll("-", "_");
        int columnIndex = 0;
        for (TblColRef col : this.cubeDesc.listDimensionColumnsExcludingDerived(false)) {
            this.columnIndexMap.put(col, columnIndex);
            this.columnList.add(col);
            ++columnIndex;
        }
        List<MeasureDesc> measures = this.cubeDesc.getMeasures();
        int measureSize = measures.size();
        for (int i = 0; i < measureSize; ++i) {
            FunctionDesc func = measures.get(i).getFunction();
            List<TblColRef> colRefs = func.getParameter().getColRefs();
            if (colRefs == null) continue;
            for (int j = 0; j < colRefs.size(); ++j) {
                TblColRef c = colRefs.get(j);
                if (this.columnList.indexOf(c) >= 0) continue;
                this.columnIndexMap.put(c, columnIndex);
                this.columnList.add(c);
                ++columnIndex;
            }
        }
        if (this.cubeDesc.getDictionaries() != null) {
            for (DictionaryDesc dictDesc : this.cubeDesc.getDictionaries()) {
                TblColRef c = dictDesc.getColumnRef();
                if (this.columnList.indexOf(c) < 0) {
                    this.columnIndexMap.put(c, columnIndex);
                    this.columnList.add(c);
                    ++columnIndex;
                }
                if (dictDesc.getResuseColumnRef() == null || this.columnList.indexOf(c = dictDesc.getResuseColumnRef()) >= 0) continue;
                this.columnIndexMap.put(c, columnIndex);
                this.columnList.add(c);
                ++columnIndex;
            }
        }
        this.columnCount = columnIndex;
    }

    public void sanityCheck(BytesSplitter bytesSplitter) {
        if (this.columnCount != bytesSplitter.getBufferSize()) {
            throw new IllegalArgumentException("Expect " + this.columnCount + " columns, but see " + bytesSplitter.getBufferSize() + " -- " + bytesSplitter);
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public List<TblColRef> getAllColumns() {
        return this.columnList;
    }

    @Override
    public DataModelDesc getDataModel() {
        return this.cubeDesc.getModel();
    }

    @Override
    public int getColumnIndex(TblColRef colRef) {
        Integer index = this.columnIndexMap.get(colRef);
        if (index == null) {
            throw new IllegalArgumentException("Column " + colRef.toString() + " wasn't found on flat table.");
        }
        return index;
    }

    @Override
    public long getSourceOffsetStart() {
        return this.cubeSegment.getSourceOffsetStart();
    }

    @Override
    public long getSourceOffsetEnd() {
        return this.cubeSegment.getSourceOffsetEnd();
    }

    @Override
    public TblColRef getDistributedBy() {
        return this.cubeDesc.getDistributedByColumn();
    }
}

