/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.kv;

import java.util.Arrays;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.metadata.model.TblColRef;

public class FuzzyMaskEncoder
extends RowKeyEncoder {
    public FuzzyMaskEncoder(CubeSegment seg, Cuboid cuboid) {
        super(seg, cuboid);
    }

    @Override
    public void encode(GTRecord record, ImmutableBitSet keyColumns, byte[] buf) {
        ByteArray byteArray = new ByteArray(buf, this.getHeaderLength(), 0);
        GTInfo info = record.getInfo();
        int pos = 0;
        for (int i = 0; i < info.getPrimaryKey().trueBitCount(); ++i) {
            int c = info.getPrimaryKey().trueBitAt(i);
            int colLength = info.getCodeSystem().maxCodeLength(c);
            byte fill = record.get(c).array() != null ? (byte)0 : 1;
            Arrays.fill(byteArray.array(), byteArray.offset() + pos, byteArray.offset() + pos + colLength, fill);
            pos += colLength;
        }
        byteArray.setLength(pos);
        this.fillHeader(buf);
    }

    @Override
    protected void fillHeader(byte[] bytes) {
        int offset = 0;
        if (this.enableSharding) {
            Arrays.fill(bytes, 0, 2, (byte)1);
            offset += 2;
        }
        int headerLength = this.getHeaderLength();
        Arrays.fill(bytes, offset, headerLength, (byte)0);
    }

    @Override
    protected void fillColumnValue(TblColRef column, int columnLen, byte[] value, int valueLen, byte[] outputValue, int outputValueOffset) {
        if (value == null) {
            Arrays.fill(outputValue, outputValueOffset, outputValueOffset + columnLen, (byte)1);
        } else {
            Arrays.fill(outputValue, outputValueOffset, outputValueOffset + columnLen, (byte)0);
        }
    }
}

